package zio.aws.entityresolution.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{
  Timestamp,
  TagValue,
  Description,
  SchemaMappingArn,
  EntityName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class GetSchemaMappingResponse(
    createdAt: Timestamp,
    description: Optional[Description] = Optional.Absent,
    hasWorkflows: Boolean,
    mappedInputFields: Iterable[
      zio.aws.entityresolution.model.SchemaInputAttribute
    ],
    schemaArn: SchemaMappingArn,
    schemaName: EntityName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse = {
    import GetSchemaMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse
      .builder()
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .hasWorkflows(hasWorkflows: java.lang.Boolean)
      .mappedInputFields(mappedInputFields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .schemaArn(SchemaMappingArn.unwrap(schemaArn): java.lang.String)
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetSchemaMappingResponse.ReadOnly =
    zio.aws.entityresolution.model.GetSchemaMappingResponse
      .wrap(buildAwsValue())
}
object GetSchemaMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetSchemaMappingResponse =
      zio.aws.entityresolution.model.GetSchemaMappingResponse(
        createdAt,
        description.map(value => value),
        hasWorkflows,
        mappedInputFields.map { item =>
          item.asEditable
        },
        schemaArn,
        schemaName,
        tags.map(value => value),
        updatedAt
      )
    def createdAt: Timestamp
    def description: Optional[Description]
    def hasWorkflows: Boolean
    def mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly]
    def schemaArn: SchemaMappingArn
    def schemaName: EntityName
    def tags: Optional[Map[TagKey, TagValue]]
    def updatedAt: Timestamp
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getHasWorkflows: ZIO[Any, Nothing, Boolean] = ZIO.succeed(hasWorkflows)
    def getMappedInputFields: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly
    ]] = ZIO.succeed(mappedInputFields)
    def getSchemaArn: ZIO[Any, Nothing, SchemaMappingArn] =
      ZIO.succeed(schemaArn)
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse
  ) extends zio.aws.entityresolution.model.GetSchemaMappingResponse.ReadOnly {
    override val createdAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.createdAt())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.entityresolution.model.primitives.Description(value)
      )
    override val hasWorkflows: Boolean = impl.hasWorkflows(): Boolean
    override val mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly] =
      impl
        .mappedInputFields()
        .asScala
        .map { item =>
          zio.aws.entityresolution.model.SchemaInputAttribute.wrap(item)
        }
        .toList
    override val schemaArn: SchemaMappingArn =
      zio.aws.entityresolution.model.primitives
        .SchemaMappingArn(impl.schemaArn())
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.entityresolution.model.primitives.TagKey(
              key
            ) -> zio.aws.entityresolution.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updatedAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingResponse
  ): zio.aws.entityresolution.model.GetSchemaMappingResponse.ReadOnly =
    new Wrapper(impl)
}
