package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.EntityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSchemaMappingRequest(schemaName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest = {
    import GetSchemaMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest
      .builder()
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetSchemaMappingRequest.ReadOnly =
    zio.aws.entityresolution.model.GetSchemaMappingRequest.wrap(buildAwsValue())
}
object GetSchemaMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetSchemaMappingRequest =
      zio.aws.entityresolution.model.GetSchemaMappingRequest(schemaName)
    def schemaName: EntityName
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest
  ) extends zio.aws.entityresolution.model.GetSchemaMappingRequest.ReadOnly {
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest
  ): zio.aws.entityresolution.model.GetSchemaMappingRequest.ReadOnly =
    new Wrapper(impl)
}
