package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  ProviderServiceDisplayName,
  ProviderServiceArn,
  EntityName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetProviderServiceResponse(
    anonymizedOutput: Boolean,
    providerConfigurationDefinition: Optional[
      zio.aws.entityresolution.model.Document
    ] = Optional.Absent,
    providerEndpointConfiguration: zio.aws.entityresolution.model.ProviderEndpointConfiguration,
    providerEntityOutputDefinition: zio.aws.entityresolution.model.Document,
    providerIntermediateDataAccessConfiguration: Optional[
      zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration
    ] = Optional.Absent,
    providerName: EntityName,
    providerServiceArn: ProviderServiceArn,
    providerServiceDisplayName: ProviderServiceDisplayName,
    providerServiceName: EntityName,
    providerServiceType: zio.aws.entityresolution.model.ServiceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetProviderServiceResponse = {
    import GetProviderServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetProviderServiceResponse
      .builder()
      .anonymizedOutput(anonymizedOutput: java.lang.Boolean)
      .optionallyWith(providerConfigurationDefinition.map(value => value))(
        _.providerConfigurationDefinition
      )
      .providerEndpointConfiguration(
        providerEndpointConfiguration.buildAwsValue()
      )
      .providerEntityOutputDefinition(providerEntityOutputDefinition)
      .optionallyWith(
        providerIntermediateDataAccessConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.providerIntermediateDataAccessConfiguration)
      .providerName(EntityName.unwrap(providerName): java.lang.String)
      .providerServiceArn(
        ProviderServiceArn.unwrap(providerServiceArn): java.lang.String
      )
      .providerServiceDisplayName(
        ProviderServiceDisplayName.unwrap(
          providerServiceDisplayName
        ): java.lang.String
      )
      .providerServiceName(
        EntityName.unwrap(providerServiceName): java.lang.String
      )
      .providerServiceType(providerServiceType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetProviderServiceResponse.ReadOnly =
    zio.aws.entityresolution.model.GetProviderServiceResponse
      .wrap(buildAwsValue())
}
object GetProviderServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetProviderServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetProviderServiceResponse =
      zio.aws.entityresolution.model.GetProviderServiceResponse(
        anonymizedOutput,
        providerConfigurationDefinition.map(value => value),
        providerEndpointConfiguration.asEditable,
        providerEntityOutputDefinition,
        providerIntermediateDataAccessConfiguration.map(value =>
          value.asEditable
        ),
        providerName,
        providerServiceArn,
        providerServiceDisplayName,
        providerServiceName,
        providerServiceType
      )
    def anonymizedOutput: Boolean
    def providerConfigurationDefinition
        : Optional[software.amazon.awssdk.core.document.Document]
    def providerEndpointConfiguration
        : zio.aws.entityresolution.model.ProviderEndpointConfiguration.ReadOnly
    def providerEntityOutputDefinition
        : software.amazon.awssdk.core.document.Document
    def providerIntermediateDataAccessConfiguration: Optional[
      zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration.ReadOnly
    ]
    def providerName: EntityName
    def providerServiceArn: ProviderServiceArn
    def providerServiceDisplayName: ProviderServiceDisplayName
    def providerServiceName: EntityName
    def providerServiceType: zio.aws.entityresolution.model.ServiceType
    def getAnonymizedOutput: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(anonymizedOutput)
    def getProviderConfigurationDefinition
        : ZIO[Any, AwsError, software.amazon.awssdk.core.document.Document] =
      AwsError.unwrapOptionField(
        "providerConfigurationDefinition",
        providerConfigurationDefinition
      )
    def getProviderEndpointConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.entityresolution.model.ProviderEndpointConfiguration.ReadOnly
    ] = ZIO.succeed(providerEndpointConfiguration)
    def getProviderEntityOutputDefinition
        : ZIO[Any, Nothing, software.amazon.awssdk.core.document.Document] =
      ZIO.succeed(providerEntityOutputDefinition)
    def getProviderIntermediateDataAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "providerIntermediateDataAccessConfiguration",
      providerIntermediateDataAccessConfiguration
    )
    def getProviderName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(providerName)
    def getProviderServiceArn: ZIO[Any, Nothing, ProviderServiceArn] =
      ZIO.succeed(providerServiceArn)
    def getProviderServiceDisplayName
        : ZIO[Any, Nothing, ProviderServiceDisplayName] =
      ZIO.succeed(providerServiceDisplayName)
    def getProviderServiceName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(providerServiceName)
    def getProviderServiceType
        : ZIO[Any, Nothing, zio.aws.entityresolution.model.ServiceType] =
      ZIO.succeed(providerServiceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetProviderServiceResponse
  ) extends zio.aws.entityresolution.model.GetProviderServiceResponse.ReadOnly {
    override val anonymizedOutput: Boolean = impl.anonymizedOutput(): Boolean
    override val providerConfigurationDefinition
        : Optional[software.amazon.awssdk.core.document.Document] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerConfigurationDefinition())
    override val providerEndpointConfiguration
        : zio.aws.entityresolution.model.ProviderEndpointConfiguration.ReadOnly =
      zio.aws.entityresolution.model.ProviderEndpointConfiguration
        .wrap(impl.providerEndpointConfiguration())
    override val providerEntityOutputDefinition
        : software.amazon.awssdk.core.document.Document =
      impl.providerEntityOutputDefinition()
    override val providerIntermediateDataAccessConfiguration: Optional[
      zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.providerIntermediateDataAccessConfiguration())
      .map(value =>
        zio.aws.entityresolution.model.ProviderIntermediateDataAccessConfiguration
          .wrap(value)
      )
    override val providerName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.providerName())
    override val providerServiceArn: ProviderServiceArn =
      zio.aws.entityresolution.model.primitives
        .ProviderServiceArn(impl.providerServiceArn())
    override val providerServiceDisplayName: ProviderServiceDisplayName =
      zio.aws.entityresolution.model.primitives
        .ProviderServiceDisplayName(impl.providerServiceDisplayName())
    override val providerServiceName: EntityName =
      zio.aws.entityresolution.model.primitives
        .EntityName(impl.providerServiceName())
    override val providerServiceType
        : zio.aws.entityresolution.model.ServiceType =
      zio.aws.entityresolution.model.ServiceType
        .wrap(impl.providerServiceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetProviderServiceResponse
  ): zio.aws.entityresolution.model.GetProviderServiceResponse.ReadOnly =
    new Wrapper(impl)
}
