package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  ProviderServiceArn,
  EntityName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetProviderServiceRequest(
    providerName: EntityName,
    providerServiceName: ProviderServiceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest = {
    import GetProviderServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest
      .builder()
      .providerName(EntityName.unwrap(providerName): java.lang.String)
      .providerServiceName(
        ProviderServiceArn.unwrap(providerServiceName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetProviderServiceRequest.ReadOnly =
    zio.aws.entityresolution.model.GetProviderServiceRequest
      .wrap(buildAwsValue())
}
object GetProviderServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetProviderServiceRequest =
      zio.aws.entityresolution.model
        .GetProviderServiceRequest(providerName, providerServiceName)
    def providerName: EntityName
    def providerServiceName: ProviderServiceArn
    def getProviderName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(providerName)
    def getProviderServiceName: ZIO[Any, Nothing, ProviderServiceArn] =
      ZIO.succeed(providerServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest
  ) extends zio.aws.entityresolution.model.GetProviderServiceRequest.ReadOnly {
    override val providerName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.providerName())
    override val providerServiceName: ProviderServiceArn =
      zio.aws.entityresolution.model.primitives
        .ProviderServiceArn(impl.providerServiceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest
  ): zio.aws.entityresolution.model.GetProviderServiceRequest.ReadOnly =
    new Wrapper(impl)
}
