package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.EntityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMatchingWorkflowRequest(workflowName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest = {
    import GetMatchingWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest
      .builder()
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetMatchingWorkflowRequest.ReadOnly =
    zio.aws.entityresolution.model.GetMatchingWorkflowRequest
      .wrap(buildAwsValue())
}
object GetMatchingWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetMatchingWorkflowRequest =
      zio.aws.entityresolution.model.GetMatchingWorkflowRequest(workflowName)
    def workflowName: EntityName
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest
  ) extends zio.aws.entityresolution.model.GetMatchingWorkflowRequest.ReadOnly {
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest
  ): zio.aws.entityresolution.model.GetMatchingWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
