package zio.aws.entityresolution.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{JobId, Timestamp}
import scala.jdk.CollectionConverters._
final case class GetMatchingJobResponse(
    endTime: Optional[Timestamp] = Optional.Absent,
    errorDetails: Optional[zio.aws.entityresolution.model.ErrorDetails] =
      Optional.Absent,
    jobId: JobId,
    metrics: Optional[zio.aws.entityresolution.model.JobMetrics] =
      Optional.Absent,
    startTime: Timestamp,
    status: zio.aws.entityresolution.model.JobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse = {
    import GetMatchingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetMatchingJobResponse.ReadOnly =
    zio.aws.entityresolution.model.GetMatchingJobResponse.wrap(buildAwsValue())
}
object GetMatchingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetMatchingJobResponse =
      zio.aws.entityresolution.model.GetMatchingJobResponse(
        endTime.map(value => value),
        errorDetails.map(value => value.asEditable),
        jobId,
        metrics.map(value => value.asEditable),
        startTime,
        status
      )
    def endTime: Optional[Timestamp]
    def errorDetails
        : Optional[zio.aws.entityresolution.model.ErrorDetails.ReadOnly]
    def jobId: JobId
    def metrics: Optional[zio.aws.entityresolution.model.JobMetrics.ReadOnly]
    def startTime: Timestamp
    def status: zio.aws.entityresolution.model.JobStatus
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.ErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.JobMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("metrics", metrics)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.entityresolution.model.JobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse
  ) extends zio.aws.entityresolution.model.GetMatchingJobResponse.ReadOnly {
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.entityresolution.model.primitives.Timestamp(value))
    override val errorDetails
        : Optional[zio.aws.entityresolution.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value => zio.aws.entityresolution.model.ErrorDetails.wrap(value))
    override val jobId: JobId =
      zio.aws.entityresolution.model.primitives.JobId(impl.jobId())
    override val metrics
        : Optional[zio.aws.entityresolution.model.JobMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value => zio.aws.entityresolution.model.JobMetrics.wrap(value))
    override val startTime: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.startTime())
    override val status: zio.aws.entityresolution.model.JobStatus =
      zio.aws.entityresolution.model.JobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchingJobResponse
  ): zio.aws.entityresolution.model.GetMatchingJobResponse.ReadOnly =
    new Wrapper(impl)
}
