package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{EntityName, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMatchingJobRequest(jobId: JobId, workflowName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest = {
    import GetMatchingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetMatchingJobRequest.ReadOnly =
    zio.aws.entityresolution.model.GetMatchingJobRequest.wrap(buildAwsValue())
}
object GetMatchingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetMatchingJobRequest =
      zio.aws.entityresolution.model.GetMatchingJobRequest(jobId, workflowName)
    def jobId: JobId
    def workflowName: EntityName
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest
  ) extends zio.aws.entityresolution.model.GetMatchingJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.entityresolution.model.primitives.JobId(impl.jobId())
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest
  ): zio.aws.entityresolution.model.GetMatchingJobRequest.ReadOnly =
    new Wrapper(impl)
}
