package zio.aws.entityresolution.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMatchIdResponse(
    matchId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse = {
    import GetMatchIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse
      .builder()
      .optionallyWith(matchId.map(value => value: java.lang.String))(_.matchId)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.GetMatchIdResponse.ReadOnly =
    zio.aws.entityresolution.model.GetMatchIdResponse.wrap(buildAwsValue())
}
object GetMatchIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetMatchIdResponse =
      zio.aws.entityresolution.model
        .GetMatchIdResponse(matchId.map(value => value))
    def matchId: Optional[String]
    def getMatchId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("matchId", matchId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse
  ) extends zio.aws.entityresolution.model.GetMatchIdResponse.ReadOnly {
    override val matchId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.matchId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchIdResponse
  ): zio.aws.entityresolution.model.GetMatchIdResponse.ReadOnly = new Wrapper(
    impl
  )
}
