package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  RecordAttributeMapValueString,
  RecordAttributeMapKeyString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMatchIdRequest(
    record: Map[RecordAttributeMapKeyString, RecordAttributeMapValueString],
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest = {
    import GetMatchIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest
      .builder()
      .record(
        record
          .map({ case (key, value) =>
            (RecordAttributeMapKeyString
              .unwrap(key): java.lang.String) -> (RecordAttributeMapValueString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.GetMatchIdRequest.ReadOnly =
    zio.aws.entityresolution.model.GetMatchIdRequest.wrap(buildAwsValue())
}
object GetMatchIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetMatchIdRequest =
      zio.aws.entityresolution.model.GetMatchIdRequest(record, workflowName)
    def record: Map[RecordAttributeMapKeyString, RecordAttributeMapValueString]
    def workflowName: EntityName
    def getRecord: ZIO[Any, Nothing, Map[
      RecordAttributeMapKeyString,
      RecordAttributeMapValueString
    ]] = ZIO.succeed(record)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest
  ) extends zio.aws.entityresolution.model.GetMatchIdRequest.ReadOnly {
    override val record
        : Map[RecordAttributeMapKeyString, RecordAttributeMapValueString] = impl
      .record()
      .asScala
      .map({ case (key, value) =>
        zio.aws.entityresolution.model.primitives.RecordAttributeMapKeyString(
          key
        ) -> zio.aws.entityresolution.model.primitives
          .RecordAttributeMapValueString(value)
      })
      .toMap
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest
  ): zio.aws.entityresolution.model.GetMatchIdRequest.ReadOnly = new Wrapper(
    impl
  )
}
