package zio.aws.entityresolution.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{
  RoleArn,
  Timestamp,
  TagValue,
  IdMappingWorkflowArn,
  Description,
  EntityName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class GetIdMappingWorkflowResponse(
    createdAt: Timestamp,
    description: Optional[Description] = Optional.Absent,
    idMappingTechniques: zio.aws.entityresolution.model.IdMappingTechniques,
    inputSourceConfig: Iterable[
      zio.aws.entityresolution.model.IdMappingWorkflowInputSource
    ],
    outputSourceConfig: Iterable[
      zio.aws.entityresolution.model.IdMappingWorkflowOutputSource
    ],
    roleArn: RoleArn,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    updatedAt: Timestamp,
    workflowArn: IdMappingWorkflowArn,
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowResponse = {
    import GetIdMappingWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowResponse
      .builder()
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .idMappingTechniques(idMappingTechniques.buildAwsValue())
      .inputSourceConfig(inputSourceConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputSourceConfig(outputSourceConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .workflowArn(IdMappingWorkflowArn.unwrap(workflowArn): java.lang.String)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.ReadOnly =
    zio.aws.entityresolution.model.GetIdMappingWorkflowResponse
      .wrap(buildAwsValue())
}
object GetIdMappingWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.GetIdMappingWorkflowResponse =
      zio.aws.entityresolution.model.GetIdMappingWorkflowResponse(
        createdAt,
        description.map(value => value),
        idMappingTechniques.asEditable,
        inputSourceConfig.map { item =>
          item.asEditable
        },
        outputSourceConfig.map { item =>
          item.asEditable
        },
        roleArn,
        tags.map(value => value),
        updatedAt,
        workflowArn,
        workflowName
      )
    def createdAt: Timestamp
    def description: Optional[Description]
    def idMappingTechniques
        : zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly
    def inputSourceConfig: List[
      zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly
    ]
    def outputSourceConfig: List[
      zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly
    ]
    def roleArn: RoleArn
    def tags: Optional[Map[TagKey, TagValue]]
    def updatedAt: Timestamp
    def workflowArn: IdMappingWorkflowArn
    def workflowName: EntityName
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIdMappingTechniques: ZIO[
      Any,
      Nothing,
      zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly
    ] = ZIO.succeed(idMappingTechniques)
    def getInputSourceConfig: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly
    ]] = ZIO.succeed(inputSourceConfig)
    def getOutputSourceConfig: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly
    ]] = ZIO.succeed(outputSourceConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getWorkflowArn: ZIO[Any, Nothing, IdMappingWorkflowArn] =
      ZIO.succeed(workflowArn)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowResponse
  ) extends zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.ReadOnly {
    override val createdAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.createdAt())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.entityresolution.model.primitives.Description(value)
      )
    override val idMappingTechniques
        : zio.aws.entityresolution.model.IdMappingTechniques.ReadOnly =
      zio.aws.entityresolution.model.IdMappingTechniques
        .wrap(impl.idMappingTechniques())
    override val inputSourceConfig: List[
      zio.aws.entityresolution.model.IdMappingWorkflowInputSource.ReadOnly
    ] = impl
      .inputSourceConfig()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.IdMappingWorkflowInputSource.wrap(item)
      }
      .toList
    override val outputSourceConfig: List[
      zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.ReadOnly
    ] = impl
      .outputSourceConfig()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.IdMappingWorkflowOutputSource.wrap(item)
      }
      .toList
    override val roleArn: RoleArn =
      zio.aws.entityresolution.model.primitives.RoleArn(impl.roleArn())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.entityresolution.model.primitives.TagKey(
              key
            ) -> zio.aws.entityresolution.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updatedAt: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.updatedAt())
    override val workflowArn: IdMappingWorkflowArn =
      zio.aws.entityresolution.model.primitives
        .IdMappingWorkflowArn(impl.workflowArn())
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowResponse
  ): zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.ReadOnly =
    new Wrapper(impl)
}
