package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.EntityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetIdMappingWorkflowRequest(workflowName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest = {
    import GetIdMappingWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest
      .builder()
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetIdMappingWorkflowRequest.ReadOnly =
    zio.aws.entityresolution.model.GetIdMappingWorkflowRequest
      .wrap(buildAwsValue())
}
object GetIdMappingWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetIdMappingWorkflowRequest =
      zio.aws.entityresolution.model.GetIdMappingWorkflowRequest(workflowName)
    def workflowName: EntityName
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest
  ) extends zio.aws.entityresolution.model.GetIdMappingWorkflowRequest.ReadOnly {
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest
  ): zio.aws.entityresolution.model.GetIdMappingWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
