package zio.aws.entityresolution.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.entityresolution.model.primitives.{JobId, Timestamp}
import scala.jdk.CollectionConverters._
final case class GetIdMappingJobResponse(
    endTime: Optional[Timestamp] = Optional.Absent,
    errorDetails: Optional[zio.aws.entityresolution.model.ErrorDetails] =
      Optional.Absent,
    jobId: JobId,
    metrics: Optional[zio.aws.entityresolution.model.IdMappingJobMetrics] =
      Optional.Absent,
    startTime: Timestamp,
    status: zio.aws.entityresolution.model.JobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobResponse = {
    import GetIdMappingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobResponse
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetIdMappingJobResponse.ReadOnly =
    zio.aws.entityresolution.model.GetIdMappingJobResponse.wrap(buildAwsValue())
}
object GetIdMappingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetIdMappingJobResponse =
      zio.aws.entityresolution.model.GetIdMappingJobResponse(
        endTime.map(value => value),
        errorDetails.map(value => value.asEditable),
        jobId,
        metrics.map(value => value.asEditable),
        startTime,
        status
      )
    def endTime: Optional[Timestamp]
    def errorDetails
        : Optional[zio.aws.entityresolution.model.ErrorDetails.ReadOnly]
    def jobId: JobId
    def metrics
        : Optional[zio.aws.entityresolution.model.IdMappingJobMetrics.ReadOnly]
    def startTime: Timestamp
    def status: zio.aws.entityresolution.model.JobStatus
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.ErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.IdMappingJobMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("metrics", metrics)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.entityresolution.model.JobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobResponse
  ) extends zio.aws.entityresolution.model.GetIdMappingJobResponse.ReadOnly {
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.entityresolution.model.primitives.Timestamp(value))
    override val errorDetails
        : Optional[zio.aws.entityresolution.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value => zio.aws.entityresolution.model.ErrorDetails.wrap(value))
    override val jobId: JobId =
      zio.aws.entityresolution.model.primitives.JobId(impl.jobId())
    override val metrics: Optional[
      zio.aws.entityresolution.model.IdMappingJobMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metrics())
      .map(value =>
        zio.aws.entityresolution.model.IdMappingJobMetrics.wrap(value)
      )
    override val startTime: Timestamp =
      zio.aws.entityresolution.model.primitives.Timestamp(impl.startTime())
    override val status: zio.aws.entityresolution.model.JobStatus =
      zio.aws.entityresolution.model.JobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobResponse
  ): zio.aws.entityresolution.model.GetIdMappingJobResponse.ReadOnly =
    new Wrapper(impl)
}
