package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{EntityName, JobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetIdMappingJobRequest(
    jobId: JobId,
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest = {
    import GetIdMappingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.GetIdMappingJobRequest.ReadOnly =
    zio.aws.entityresolution.model.GetIdMappingJobRequest.wrap(buildAwsValue())
}
object GetIdMappingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.GetIdMappingJobRequest =
      zio.aws.entityresolution.model.GetIdMappingJobRequest(jobId, workflowName)
    def jobId: JobId
    def workflowName: EntityName
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest
  ) extends zio.aws.entityresolution.model.GetIdMappingJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.entityresolution.model.primitives.JobId(impl.jobId())
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest
  ): zio.aws.entityresolution.model.GetIdMappingJobRequest.ReadOnly =
    new Wrapper(impl)
}
