package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.ErrorMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ErrorDetails(
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.ErrorDetails
      .builder()
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.entityresolution.model.ErrorDetails.ReadOnly =
    zio.aws.entityresolution.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.ErrorDetails =
      zio.aws.entityresolution.model
        .ErrorDetails(errorMessage.map(value => value))
    def errorMessage: Optional[ErrorMessage]
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.ErrorDetails
  ) extends zio.aws.entityresolution.model.ErrorDetails.ReadOnly {
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value =>
        zio.aws.entityresolution.model.primitives.ErrorMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.ErrorDetails
  ): zio.aws.entityresolution.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
