package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.EntityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSchemaMappingRequest(schemaName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest = {
    import DeleteSchemaMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest
      .builder()
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.DeleteSchemaMappingRequest.ReadOnly =
    zio.aws.entityresolution.model.DeleteSchemaMappingRequest
      .wrap(buildAwsValue())
}
object DeleteSchemaMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.DeleteSchemaMappingRequest =
      zio.aws.entityresolution.model.DeleteSchemaMappingRequest(schemaName)
    def schemaName: EntityName
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest
  ) extends zio.aws.entityresolution.model.DeleteSchemaMappingRequest.ReadOnly {
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest
  ): zio.aws.entityresolution.model.DeleteSchemaMappingRequest.ReadOnly =
    new Wrapper(impl)
}
