package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.EntityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMatchingWorkflowRequest(workflowName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest = {
    import DeleteMatchingWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest
      .builder()
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.DeleteMatchingWorkflowRequest.ReadOnly =
    zio.aws.entityresolution.model.DeleteMatchingWorkflowRequest
      .wrap(buildAwsValue())
}
object DeleteMatchingWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.DeleteMatchingWorkflowRequest =
      zio.aws.entityresolution.model.DeleteMatchingWorkflowRequest(workflowName)
    def workflowName: EntityName
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest
  ) extends zio.aws.entityresolution.model.DeleteMatchingWorkflowRequest.ReadOnly {
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest
  ): zio.aws.entityresolution.model.DeleteMatchingWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
