package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.EntityName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIdMappingWorkflowRequest(workflowName: EntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest = {
    import DeleteIdMappingWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest
      .builder()
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.DeleteIdMappingWorkflowRequest.ReadOnly =
    zio.aws.entityresolution.model.DeleteIdMappingWorkflowRequest
      .wrap(buildAwsValue())
}
object DeleteIdMappingWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.DeleteIdMappingWorkflowRequest =
      zio.aws.entityresolution.model
        .DeleteIdMappingWorkflowRequest(workflowName)
    def workflowName: EntityName
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest
  ) extends zio.aws.entityresolution.model.DeleteIdMappingWorkflowRequest.ReadOnly {
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest
  ): zio.aws.entityresolution.model.DeleteIdMappingWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
