package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  SchemaMappingArn,
  Description
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateSchemaMappingResponse(
    description: Description,
    mappedInputFields: Iterable[
      zio.aws.entityresolution.model.SchemaInputAttribute
    ],
    schemaArn: SchemaMappingArn,
    schemaName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse = {
    import CreateSchemaMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse
      .builder()
      .description(Description.unwrap(description): java.lang.String)
      .mappedInputFields(mappedInputFields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .schemaArn(SchemaMappingArn.unwrap(schemaArn): java.lang.String)
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.CreateSchemaMappingResponse.ReadOnly =
    zio.aws.entityresolution.model.CreateSchemaMappingResponse
      .wrap(buildAwsValue())
}
object CreateSchemaMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.CreateSchemaMappingResponse =
      zio.aws.entityresolution.model.CreateSchemaMappingResponse(
        description,
        mappedInputFields.map { item =>
          item.asEditable
        },
        schemaArn,
        schemaName
      )
    def description: Description
    def mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly]
    def schemaArn: SchemaMappingArn
    def schemaName: EntityName
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getMappedInputFields: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly
    ]] = ZIO.succeed(mappedInputFields)
    def getSchemaArn: ZIO[Any, Nothing, SchemaMappingArn] =
      ZIO.succeed(schemaArn)
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse
  ) extends zio.aws.entityresolution.model.CreateSchemaMappingResponse.ReadOnly {
    override val description: Description =
      zio.aws.entityresolution.model.primitives.Description(impl.description())
    override val mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly] =
      impl
        .mappedInputFields()
        .asScala
        .map { item =>
          zio.aws.entityresolution.model.SchemaInputAttribute.wrap(item)
        }
        .toList
    override val schemaArn: SchemaMappingArn =
      zio.aws.entityresolution.model.primitives
        .SchemaMappingArn(impl.schemaArn())
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingResponse
  ): zio.aws.entityresolution.model.CreateSchemaMappingResponse.ReadOnly =
    new Wrapper(impl)
}
