package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  TagValue,
  TagKey,
  EntityName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSchemaMappingRequest(
    description: Optional[Description] = Optional.Absent,
    mappedInputFields: Iterable[
      zio.aws.entityresolution.model.SchemaInputAttribute
    ],
    schemaName: EntityName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest = {
    import CreateSchemaMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .mappedInputFields(mappedInputFields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .schemaName(EntityName.unwrap(schemaName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.CreateSchemaMappingRequest.ReadOnly =
    zio.aws.entityresolution.model.CreateSchemaMappingRequest
      .wrap(buildAwsValue())
}
object CreateSchemaMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.entityresolution.model.CreateSchemaMappingRequest =
      zio.aws.entityresolution.model.CreateSchemaMappingRequest(
        description.map(value => value),
        mappedInputFields.map { item =>
          item.asEditable
        },
        schemaName,
        tags.map(value => value)
      )
    def description: Optional[Description]
    def mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly]
    def schemaName: EntityName
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMappedInputFields: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly
    ]] = ZIO.succeed(mappedInputFields)
    def getSchemaName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(schemaName)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest
  ) extends zio.aws.entityresolution.model.CreateSchemaMappingRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.entityresolution.model.primitives.Description(value)
      )
    override val mappedInputFields
        : List[zio.aws.entityresolution.model.SchemaInputAttribute.ReadOnly] =
      impl
        .mappedInputFields()
        .asScala
        .map { item =>
          zio.aws.entityresolution.model.SchemaInputAttribute.wrap(item)
        }
        .toList
    override val schemaName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.schemaName())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.entityresolution.model.primitives.TagKey(
              key
            ) -> zio.aws.entityresolution.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest
  ): zio.aws.entityresolution.model.CreateSchemaMappingRequest.ReadOnly =
    new Wrapper(impl)
}
