package zio.aws.entityresolution.model
import zio.aws.entityresolution.model.primitives.{
  EntityName,
  TagValue,
  TagKey,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateMatchingWorkflowRequest(
    description: Optional[Description] = Optional.Absent,
    incrementalRunConfig: Optional[
      zio.aws.entityresolution.model.IncrementalRunConfig
    ] = Optional.Absent,
    inputSourceConfig: Iterable[zio.aws.entityresolution.model.InputSource],
    outputSourceConfig: Iterable[zio.aws.entityresolution.model.OutputSource],
    resolutionTechniques: zio.aws.entityresolution.model.ResolutionTechniques,
    roleArn: String,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    workflowName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest = {
    import CreateMatchingWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(incrementalRunConfig.map(value => value.buildAwsValue()))(
        _.incrementalRunConfig
      )
      .inputSourceConfig(inputSourceConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputSourceConfig(outputSourceConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .resolutionTechniques(resolutionTechniques.buildAwsValue())
      .roleArn(roleArn: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .workflowName(EntityName.unwrap(workflowName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.entityresolution.model.CreateMatchingWorkflowRequest.ReadOnly =
    zio.aws.entityresolution.model.CreateMatchingWorkflowRequest
      .wrap(buildAwsValue())
}
object CreateMatchingWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.entityresolution.model.CreateMatchingWorkflowRequest =
      zio.aws.entityresolution.model.CreateMatchingWorkflowRequest(
        description.map(value => value),
        incrementalRunConfig.map(value => value.asEditable),
        inputSourceConfig.map { item =>
          item.asEditable
        },
        outputSourceConfig.map { item =>
          item.asEditable
        },
        resolutionTechniques.asEditable,
        roleArn,
        tags.map(value => value),
        workflowName
      )
    def description: Optional[Description]
    def incrementalRunConfig
        : Optional[zio.aws.entityresolution.model.IncrementalRunConfig.ReadOnly]
    def inputSourceConfig
        : List[zio.aws.entityresolution.model.InputSource.ReadOnly]
    def outputSourceConfig
        : List[zio.aws.entityresolution.model.OutputSource.ReadOnly]
    def resolutionTechniques
        : zio.aws.entityresolution.model.ResolutionTechniques.ReadOnly
    def roleArn: String
    def tags: Optional[Map[TagKey, TagValue]]
    def workflowName: EntityName
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getIncrementalRunConfig: ZIO[
      Any,
      AwsError,
      zio.aws.entityresolution.model.IncrementalRunConfig.ReadOnly
    ] = AwsError.unwrapOptionField("incrementalRunConfig", incrementalRunConfig)
    def getInputSourceConfig: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.InputSource.ReadOnly
    ]] = ZIO.succeed(inputSourceConfig)
    def getOutputSourceConfig: ZIO[Any, Nothing, List[
      zio.aws.entityresolution.model.OutputSource.ReadOnly
    ]] = ZIO.succeed(outputSourceConfig)
    def getResolutionTechniques: ZIO[
      Any,
      Nothing,
      zio.aws.entityresolution.model.ResolutionTechniques.ReadOnly
    ] = ZIO.succeed(resolutionTechniques)
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkflowName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(workflowName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest
  ) extends zio.aws.entityresolution.model.CreateMatchingWorkflowRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.entityresolution.model.primitives.Description(value)
      )
    override val incrementalRunConfig: Optional[
      zio.aws.entityresolution.model.IncrementalRunConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.incrementalRunConfig())
      .map(value =>
        zio.aws.entityresolution.model.IncrementalRunConfig.wrap(value)
      )
    override val inputSourceConfig
        : List[zio.aws.entityresolution.model.InputSource.ReadOnly] = impl
      .inputSourceConfig()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.InputSource.wrap(item)
      }
      .toList
    override val outputSourceConfig
        : List[zio.aws.entityresolution.model.OutputSource.ReadOnly] = impl
      .outputSourceConfig()
      .asScala
      .map { item =>
        zio.aws.entityresolution.model.OutputSource.wrap(item)
      }
      .toList
    override val resolutionTechniques
        : zio.aws.entityresolution.model.ResolutionTechniques.ReadOnly =
      zio.aws.entityresolution.model.ResolutionTechniques
        .wrap(impl.resolutionTechniques())
    override val roleArn: String = impl.roleArn(): String
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.entityresolution.model.primitives.TagKey(
              key
            ) -> zio.aws.entityresolution.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workflowName: EntityName =
      zio.aws.entityresolution.model.primitives.EntityName(impl.workflowName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest
  ): zio.aws.entityresolution.model.CreateMatchingWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
