package zio.aws.entityresolution
import zio.aws.entityresolution.model.ListSchemaMappingsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient
import zio.aws.entityresolution.model.{
  DeleteMatchingWorkflowRequest,
  CreateMatchingWorkflowRequest,
  GetMatchingWorkflowRequest,
  ListMatchingWorkflowsRequest,
  UpdateIdMappingWorkflowRequest,
  DeleteIdMappingWorkflowRequest,
  ListSchemaMappingsRequest,
  ListTagsForResourceRequest,
  UpdateMatchingWorkflowRequest,
  GetProviderServiceRequest,
  DeleteSchemaMappingRequest,
  GetSchemaMappingRequest,
  ListIdMappingWorkflowsRequest,
  ListProviderServicesRequest,
  GetMatchingJobRequest,
  StartMatchingJobRequest,
  GetIdMappingJobRequest,
  CreateIdMappingWorkflowRequest,
  UpdateSchemaMappingRequest,
  GetIdMappingWorkflowRequest,
  UntagResourceRequest,
  ListIdMappingJobsRequest,
  CreateSchemaMappingRequest,
  StartIdMappingJobRequest,
  GetMatchIdRequest,
  TagResourceRequest,
  ListMatchingJobsRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object EntityResolutionMock extends Mock[EntityResolution] {
  object GetSchemaMapping
      extends Effect[
        GetSchemaMappingRequest,
        AwsError,
        zio.aws.entityresolution.model.GetSchemaMappingResponse.ReadOnly
      ]
  object ListProviderServices
      extends Stream[
        ListProviderServicesRequest,
        AwsError,
        zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly
      ]
  object ListProviderServicesPaginated
      extends Effect[
        ListProviderServicesRequest,
        AwsError,
        zio.aws.entityresolution.model.ListProviderServicesResponse.ReadOnly
      ]
  object GetMatchingJob
      extends Effect[
        GetMatchingJobRequest,
        AwsError,
        zio.aws.entityresolution.model.GetMatchingJobResponse.ReadOnly
      ]
  object GetMatchingWorkflow
      extends Effect[
        GetMatchingWorkflowRequest,
        AwsError,
        zio.aws.entityresolution.model.GetMatchingWorkflowResponse.ReadOnly
      ]
  object UpdateSchemaMapping
      extends Effect[
        UpdateSchemaMappingRequest,
        AwsError,
        zio.aws.entityresolution.model.UpdateSchemaMappingResponse.ReadOnly
      ]
  object StartIdMappingJob
      extends Effect[
        StartIdMappingJobRequest,
        AwsError,
        zio.aws.entityresolution.model.StartIdMappingJobResponse.ReadOnly
      ]
  object ListIdMappingJobs
      extends Stream[
        ListIdMappingJobsRequest,
        AwsError,
        zio.aws.entityresolution.model.JobSummary.ReadOnly
      ]
  object ListIdMappingJobsPaginated
      extends Effect[
        ListIdMappingJobsRequest,
        AwsError,
        zio.aws.entityresolution.model.ListIdMappingJobsResponse.ReadOnly
      ]
  object UpdateIdMappingWorkflow
      extends Effect[
        UpdateIdMappingWorkflowRequest,
        AwsError,
        zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.ReadOnly
      ]
  object StartMatchingJob
      extends Effect[
        StartMatchingJobRequest,
        AwsError,
        zio.aws.entityresolution.model.StartMatchingJobResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.entityresolution.model.UntagResourceResponse.ReadOnly
      ]
  object ListSchemaMappings
      extends Stream[
        ListSchemaMappingsRequest,
        AwsError,
        zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly
      ]
  object ListSchemaMappingsPaginated
      extends Effect[ListSchemaMappingsRequest, AwsError, ReadOnly]
  object ListMatchingWorkflows
      extends Stream[
        ListMatchingWorkflowsRequest,
        AwsError,
        zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly
      ]
  object ListMatchingWorkflowsPaginated
      extends Effect[
        ListMatchingWorkflowsRequest,
        AwsError,
        zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.ReadOnly
      ]
  object CreateSchemaMapping
      extends Effect[
        CreateSchemaMappingRequest,
        AwsError,
        zio.aws.entityresolution.model.CreateSchemaMappingResponse.ReadOnly
      ]
  object GetIdMappingJob
      extends Effect[
        GetIdMappingJobRequest,
        AwsError,
        zio.aws.entityresolution.model.GetIdMappingJobResponse.ReadOnly
      ]
  object GetProviderService
      extends Effect[
        GetProviderServiceRequest,
        AwsError,
        zio.aws.entityresolution.model.GetProviderServiceResponse.ReadOnly
      ]
  object UpdateMatchingWorkflow
      extends Effect[
        UpdateMatchingWorkflowRequest,
        AwsError,
        zio.aws.entityresolution.model.UpdateMatchingWorkflowResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.entityresolution.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.entityresolution.model.TagResourceResponse.ReadOnly
      ]
  object ListIdMappingWorkflows
      extends Stream[
        ListIdMappingWorkflowsRequest,
        AwsError,
        zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly
      ]
  object ListIdMappingWorkflowsPaginated
      extends Effect[
        ListIdMappingWorkflowsRequest,
        AwsError,
        zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.ReadOnly
      ]
  object GetMatchId
      extends Effect[
        GetMatchIdRequest,
        AwsError,
        zio.aws.entityresolution.model.GetMatchIdResponse.ReadOnly
      ]
  object DeleteIdMappingWorkflow
      extends Effect[
        DeleteIdMappingWorkflowRequest,
        AwsError,
        zio.aws.entityresolution.model.DeleteIdMappingWorkflowResponse.ReadOnly
      ]
  object DeleteSchemaMapping
      extends Effect[
        DeleteSchemaMappingRequest,
        AwsError,
        zio.aws.entityresolution.model.DeleteSchemaMappingResponse.ReadOnly
      ]
  object GetIdMappingWorkflow
      extends Effect[
        GetIdMappingWorkflowRequest,
        AwsError,
        zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.ReadOnly
      ]
  object CreateMatchingWorkflow
      extends Effect[
        CreateMatchingWorkflowRequest,
        AwsError,
        zio.aws.entityresolution.model.CreateMatchingWorkflowResponse.ReadOnly
      ]
  object ListMatchingJobs
      extends Stream[
        ListMatchingJobsRequest,
        AwsError,
        zio.aws.entityresolution.model.JobSummary.ReadOnly
      ]
  object ListMatchingJobsPaginated
      extends Effect[
        ListMatchingJobsRequest,
        AwsError,
        zio.aws.entityresolution.model.ListMatchingJobsResponse.ReadOnly
      ]
  object DeleteMatchingWorkflow
      extends Effect[
        DeleteMatchingWorkflowRequest,
        AwsError,
        zio.aws.entityresolution.model.DeleteMatchingWorkflowResponse.ReadOnly
      ]
  object CreateIdMappingWorkflow
      extends Effect[
        CreateIdMappingWorkflowRequest,
        AwsError,
        zio.aws.entityresolution.model.CreateIdMappingWorkflowResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, EntityResolution] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, EntityResolution] { rts =>
        zio.ZIO.succeed {
          new EntityResolution {
            val api: EntityResolutionAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): EntityResolution = this
            def getSchemaMapping(request: GetSchemaMappingRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.GetSchemaMappingResponse.ReadOnly
            ] = proxy(GetSchemaMapping, request)
            def listProviderServices(
                request: ListProviderServicesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProviderServices, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProviderServicesPaginated(
                request: ListProviderServicesRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.ListProviderServicesResponse.ReadOnly
            ] = proxy(ListProviderServicesPaginated, request)
            def getMatchingJob(request: GetMatchingJobRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.GetMatchingJobResponse.ReadOnly
            ] = proxy(GetMatchingJob, request)
            def getMatchingWorkflow(request: GetMatchingWorkflowRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.GetMatchingWorkflowResponse.ReadOnly
            ] = proxy(GetMatchingWorkflow, request)
            def updateSchemaMapping(request: UpdateSchemaMappingRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.UpdateSchemaMappingResponse.ReadOnly
            ] = proxy(UpdateSchemaMapping, request)
            def startIdMappingJob(request: StartIdMappingJobRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.StartIdMappingJobResponse.ReadOnly
            ] = proxy(StartIdMappingJob, request)
            def listIdMappingJobs(request: ListIdMappingJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.entityresolution.model.JobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListIdMappingJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listIdMappingJobsPaginated(
                request: ListIdMappingJobsRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.ListIdMappingJobsResponse.ReadOnly
            ] = proxy(ListIdMappingJobsPaginated, request)
            def updateIdMappingWorkflow(
                request: UpdateIdMappingWorkflowRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.ReadOnly
            ] = proxy(UpdateIdMappingWorkflow, request)
            def startMatchingJob(request: StartMatchingJobRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.StartMatchingJobResponse.ReadOnly
            ] = proxy(StartMatchingJob, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listSchemaMappings(request: ListSchemaMappingsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSchemaMappings, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSchemaMappingsPaginated(
                request: ListSchemaMappingsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListSchemaMappingsPaginated, request)
            def listMatchingWorkflows(
                request: ListMatchingWorkflowsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMatchingWorkflows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMatchingWorkflowsPaginated(
                request: ListMatchingWorkflowsRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.ReadOnly
            ] = proxy(ListMatchingWorkflowsPaginated, request)
            def createSchemaMapping(request: CreateSchemaMappingRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.CreateSchemaMappingResponse.ReadOnly
            ] = proxy(CreateSchemaMapping, request)
            def getIdMappingJob(request: GetIdMappingJobRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.GetIdMappingJobResponse.ReadOnly
            ] = proxy(GetIdMappingJob, request)
            def getProviderService(request: GetProviderServiceRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.GetProviderServiceResponse.ReadOnly
            ] = proxy(GetProviderService, request)
            def updateMatchingWorkflow(
                request: UpdateMatchingWorkflowRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.UpdateMatchingWorkflowResponse.ReadOnly
            ] = proxy(UpdateMatchingWorkflow, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listIdMappingWorkflows(
                request: ListIdMappingWorkflowsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListIdMappingWorkflows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listIdMappingWorkflowsPaginated(
                request: ListIdMappingWorkflowsRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.ReadOnly
            ] = proxy(ListIdMappingWorkflowsPaginated, request)
            def getMatchId(request: GetMatchIdRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.GetMatchIdResponse.ReadOnly
            ] = proxy(GetMatchId, request)
            def deleteIdMappingWorkflow(
                request: DeleteIdMappingWorkflowRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.DeleteIdMappingWorkflowResponse.ReadOnly
            ] = proxy(DeleteIdMappingWorkflow, request)
            def deleteSchemaMapping(request: DeleteSchemaMappingRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.DeleteSchemaMappingResponse.ReadOnly
            ] = proxy(DeleteSchemaMapping, request)
            def getIdMappingWorkflow(request: GetIdMappingWorkflowRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.ReadOnly
            ] = proxy(GetIdMappingWorkflow, request)
            def createMatchingWorkflow(
                request: CreateMatchingWorkflowRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.CreateMatchingWorkflowResponse.ReadOnly
            ] = proxy(CreateMatchingWorkflow, request)
            def listMatchingJobs(request: ListMatchingJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.entityresolution.model.JobSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMatchingJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMatchingJobsPaginated(request: ListMatchingJobsRequest): IO[
              AwsError,
              zio.aws.entityresolution.model.ListMatchingJobsResponse.ReadOnly
            ] = proxy(ListMatchingJobsPaginated, request)
            def deleteMatchingWorkflow(
                request: DeleteMatchingWorkflowRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.DeleteMatchingWorkflowResponse.ReadOnly
            ] = proxy(DeleteMatchingWorkflow, request)
            def createIdMappingWorkflow(
                request: CreateIdMappingWorkflowRequest
            ): IO[
              AwsError,
              zio.aws.entityresolution.model.CreateIdMappingWorkflowResponse.ReadOnly
            ] = proxy(CreateIdMappingWorkflow, request)
          }
        }
      }
    }
  }
}
