package zio.aws.entityresolution
import zio.aws.entityresolution.model.ListSchemaMappingsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.entityresolution.{
  EntityResolutionAsyncClientBuilder,
  EntityResolutionAsyncClient
}
import zio.aws.entityresolution.model.{
  DeleteMatchingWorkflowRequest,
  CreateMatchingWorkflowRequest,
  GetMatchingWorkflowRequest,
  ListMatchingWorkflowsRequest,
  UpdateIdMappingWorkflowRequest,
  DeleteIdMappingWorkflowRequest,
  ListSchemaMappingsRequest,
  ListTagsForResourceRequest,
  UpdateMatchingWorkflowRequest,
  GetProviderServiceRequest,
  DeleteSchemaMappingRequest,
  GetSchemaMappingRequest,
  ListIdMappingWorkflowsRequest,
  ListProviderServicesRequest,
  GetMatchingJobRequest,
  StartMatchingJobRequest,
  GetIdMappingJobRequest,
  CreateIdMappingWorkflowRequest,
  UpdateSchemaMappingRequest,
  GetIdMappingWorkflowRequest,
  UntagResourceRequest,
  ListIdMappingJobsRequest,
  CreateSchemaMappingRequest,
  StartIdMappingJobRequest,
  GetMatchIdRequest,
  TagResourceRequest,
  ListMatchingJobsRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.entityresolution.model.{
  GetProviderServiceResponse,
  ListMatchingWorkflowsResponse,
  CreateIdMappingWorkflowResponse,
  CreateMatchingWorkflowResponse,
  UpdateSchemaMappingResponse,
  UpdateIdMappingWorkflowResponse,
  StartIdMappingJobResponse,
  DeleteSchemaMappingResponse,
  IdMappingWorkflowSummary,
  GetIdMappingJobResponse,
  ListSchemaMappingsResponse,
  UpdateMatchingWorkflowResponse,
  StartMatchingJobResponse,
  GetMatchingJobResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListProviderServicesResponse,
  GetMatchingWorkflowResponse,
  SchemaMappingSummary,
  DeleteIdMappingWorkflowResponse,
  MatchingWorkflowSummary,
  ListIdMappingJobsResponse,
  GetMatchIdResponse,
  GetIdMappingWorkflowResponse,
  ListIdMappingWorkflowsResponse,
  GetSchemaMappingResponse,
  CreateSchemaMappingResponse,
  ProviderServiceSummary,
  DeleteMatchingWorkflowResponse,
  TagResourceResponse,
  JobSummary,
  ListMatchingJobsResponse
}
import software.amazon.awssdk.services.entityresolution.paginators.{
  ListMatchingWorkflowsPublisher,
  ListProviderServicesPublisher,
  ListIdMappingWorkflowsPublisher,
  ListMatchingJobsPublisher,
  ListIdMappingJobsPublisher,
  ListSchemaMappingsPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait EntityResolution extends AspectSupport[EntityResolution] {
  val api: EntityResolutionAsyncClient
  def getSchemaMapping(request: GetSchemaMappingRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.GetSchemaMappingResponse.ReadOnly
  ]
  def listProviderServices(request: ListProviderServicesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly
  ]
  def listProviderServicesPaginated(request: ListProviderServicesRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.ListProviderServicesResponse.ReadOnly
  ]
  def getMatchingJob(request: GetMatchingJobRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.GetMatchingJobResponse.ReadOnly
  ]
  def getMatchingWorkflow(request: GetMatchingWorkflowRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.GetMatchingWorkflowResponse.ReadOnly
  ]
  def updateSchemaMapping(request: UpdateSchemaMappingRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.UpdateSchemaMappingResponse.ReadOnly
  ]
  def startIdMappingJob(request: StartIdMappingJobRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.StartIdMappingJobResponse.ReadOnly
  ]
  def listIdMappingJobs(
      request: ListIdMappingJobsRequest
  ): ZStream[Any, AwsError, zio.aws.entityresolution.model.JobSummary.ReadOnly]
  def listIdMappingJobsPaginated(request: ListIdMappingJobsRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.ListIdMappingJobsResponse.ReadOnly
  ]
  def updateIdMappingWorkflow(request: UpdateIdMappingWorkflowRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.ReadOnly
  ]
  def startMatchingJob(request: StartMatchingJobRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.StartMatchingJobResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.entityresolution.model.UntagResourceResponse.ReadOnly]
  def listSchemaMappings(request: ListSchemaMappingsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly
  ]
  def listSchemaMappingsPaginated(
      request: ListSchemaMappingsRequest
  ): IO[AwsError, ReadOnly]
  def listMatchingWorkflows(request: ListMatchingWorkflowsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly
  ]
  def listMatchingWorkflowsPaginated(request: ListMatchingWorkflowsRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.ReadOnly
  ]
  def createSchemaMapping(request: CreateSchemaMappingRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.CreateSchemaMappingResponse.ReadOnly
  ]
  def getIdMappingJob(request: GetIdMappingJobRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.GetIdMappingJobResponse.ReadOnly
  ]
  def getProviderService(request: GetProviderServiceRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.GetProviderServiceResponse.ReadOnly
  ]
  def updateMatchingWorkflow(request: UpdateMatchingWorkflowRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.UpdateMatchingWorkflowResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.entityresolution.model.TagResourceResponse.ReadOnly]
  def listIdMappingWorkflows(request: ListIdMappingWorkflowsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly
  ]
  def listIdMappingWorkflowsPaginated(
      request: ListIdMappingWorkflowsRequest
  ): IO[
    AwsError,
    zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.ReadOnly
  ]
  def getMatchId(
      request: GetMatchIdRequest
  ): IO[AwsError, zio.aws.entityresolution.model.GetMatchIdResponse.ReadOnly]
  def deleteIdMappingWorkflow(request: DeleteIdMappingWorkflowRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.DeleteIdMappingWorkflowResponse.ReadOnly
  ]
  def deleteSchemaMapping(request: DeleteSchemaMappingRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.DeleteSchemaMappingResponse.ReadOnly
  ]
  def getIdMappingWorkflow(request: GetIdMappingWorkflowRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.ReadOnly
  ]
  def createMatchingWorkflow(request: CreateMatchingWorkflowRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.CreateMatchingWorkflowResponse.ReadOnly
  ]
  def listMatchingJobs(
      request: ListMatchingJobsRequest
  ): ZStream[Any, AwsError, zio.aws.entityresolution.model.JobSummary.ReadOnly]
  def listMatchingJobsPaginated(request: ListMatchingJobsRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.ListMatchingJobsResponse.ReadOnly
  ]
  def deleteMatchingWorkflow(request: DeleteMatchingWorkflowRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.DeleteMatchingWorkflowResponse.ReadOnly
  ]
  def createIdMappingWorkflow(request: CreateIdMappingWorkflowRequest): IO[
    AwsError,
    zio.aws.entityresolution.model.CreateIdMappingWorkflowResponse.ReadOnly
  ]
}
object EntityResolution {
  val live: ZLayer[AwsConfig, java.lang.Throwable, EntityResolution] =
    customized(identity)
  def customized(
      customization: EntityResolutionAsyncClientBuilder => EntityResolutionAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, EntityResolution] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: EntityResolutionAsyncClientBuilder => EntityResolutionAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, EntityResolution] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = EntityResolutionAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      EntityResolutionAsyncClient,
      EntityResolutionAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      EntityResolutionAsyncClient,
      EntityResolutionAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new EntityResolutionImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class EntityResolutionImpl[R](
      override val api: EntityResolutionAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends EntityResolution
      with AwsServiceBase[R] {
    override val serviceName: String = "EntityResolution"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): EntityResolutionImpl[R1] = new EntityResolutionImpl(api, newAspect, r)
    def getSchemaMapping(request: GetSchemaMappingRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.GetSchemaMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.GetSchemaMappingRequest,
      GetSchemaMappingResponse
    ]("getSchemaMapping", api.getSchemaMapping)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.GetSchemaMappingResponse.wrap)
      .provideEnvironment(r)
    def listProviderServices(request: ListProviderServicesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest,
      ProviderServiceSummary,
      ListProviderServicesPublisher
    ](
      "listProviderServices",
      api.listProviderServicesPaginator,
      _.providerServiceSummaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.entityresolution.model.ProviderServiceSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listProviderServicesPaginated(request: ListProviderServicesRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.ListProviderServicesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest,
      ListProviderServicesResponse
    ]("listProviderServices", api.listProviderServices)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.ListProviderServicesResponse.wrap)
      .provideEnvironment(r)
    def getMatchingJob(request: GetMatchingJobRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.GetMatchingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.GetMatchingJobRequest,
      GetMatchingJobResponse
    ]("getMatchingJob", api.getMatchingJob)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.GetMatchingJobResponse.wrap)
      .provideEnvironment(r)
    def getMatchingWorkflow(request: GetMatchingWorkflowRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.GetMatchingWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.GetMatchingWorkflowRequest,
      GetMatchingWorkflowResponse
    ]("getMatchingWorkflow", api.getMatchingWorkflow)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.GetMatchingWorkflowResponse.wrap)
      .provideEnvironment(r)
    def updateSchemaMapping(request: UpdateSchemaMappingRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.UpdateSchemaMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.UpdateSchemaMappingRequest,
      UpdateSchemaMappingResponse
    ]("updateSchemaMapping", api.updateSchemaMapping)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.UpdateSchemaMappingResponse.wrap)
      .provideEnvironment(r)
    def startIdMappingJob(request: StartIdMappingJobRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.StartIdMappingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.StartIdMappingJobRequest,
      StartIdMappingJobResponse
    ]("startIdMappingJob", api.startIdMappingJob)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.StartIdMappingJobResponse.wrap)
      .provideEnvironment(r)
    def listIdMappingJobs(request: ListIdMappingJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.entityresolution.model.JobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest,
      JobSummary,
      ListIdMappingJobsPublisher
    ]("listIdMappingJobs", api.listIdMappingJobsPaginator, _.jobs())(
      request.buildAwsValue()
    ).map(item => zio.aws.entityresolution.model.JobSummary.wrap(item))
      .provideEnvironment(r)
    def listIdMappingJobsPaginated(request: ListIdMappingJobsRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.ListIdMappingJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.ListIdMappingJobsRequest,
      ListIdMappingJobsResponse
    ]("listIdMappingJobs", api.listIdMappingJobs)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.ListIdMappingJobsResponse.wrap)
      .provideEnvironment(r)
    def updateIdMappingWorkflow(request: UpdateIdMappingWorkflowRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.UpdateIdMappingWorkflowRequest,
      UpdateIdMappingWorkflowResponse
    ]("updateIdMappingWorkflow", api.updateIdMappingWorkflow)(
      request.buildAwsValue()
    ).map(zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.wrap)
      .provideEnvironment(r)
    def startMatchingJob(request: StartMatchingJobRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.StartMatchingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.StartMatchingJobRequest,
      StartMatchingJobResponse
    ]("startMatchingJob", api.startMatchingJob)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.StartMatchingJobResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listSchemaMappings(request: ListSchemaMappingsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest,
      SchemaMappingSummary,
      ListSchemaMappingsPublisher
    ]("listSchemaMappings", api.listSchemaMappingsPaginator, _.schemaList())(
      request.buildAwsValue()
    ).map(item =>
      zio.aws.entityresolution.model.SchemaMappingSummary.wrap(item)
    ).provideEnvironment(r)
    def listSchemaMappingsPaginated(
        request: ListSchemaMappingsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.ListSchemaMappingsRequest,
      ListSchemaMappingsResponse
    ]("listSchemaMappings", api.listSchemaMappings)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.ListSchemaMappingsResponse.wrap)
      .provideEnvironment(r)
    def listMatchingWorkflows(request: ListMatchingWorkflowsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest,
      MatchingWorkflowSummary,
      ListMatchingWorkflowsPublisher
    ](
      "listMatchingWorkflows",
      api.listMatchingWorkflowsPaginator,
      _.workflowSummaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.entityresolution.model.MatchingWorkflowSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listMatchingWorkflowsPaginated(
        request: ListMatchingWorkflowsRequest
    ): IO[
      AwsError,
      zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.ListMatchingWorkflowsRequest,
      ListMatchingWorkflowsResponse
    ]("listMatchingWorkflows", api.listMatchingWorkflows)(
      request.buildAwsValue()
    ).map(zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.wrap)
      .provideEnvironment(r)
    def createSchemaMapping(request: CreateSchemaMappingRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.CreateSchemaMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.CreateSchemaMappingRequest,
      CreateSchemaMappingResponse
    ]("createSchemaMapping", api.createSchemaMapping)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.CreateSchemaMappingResponse.wrap)
      .provideEnvironment(r)
    def getIdMappingJob(request: GetIdMappingJobRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.GetIdMappingJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.GetIdMappingJobRequest,
      GetIdMappingJobResponse
    ]("getIdMappingJob", api.getIdMappingJob)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.GetIdMappingJobResponse.wrap)
      .provideEnvironment(r)
    def getProviderService(request: GetProviderServiceRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.GetProviderServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.GetProviderServiceRequest,
      GetProviderServiceResponse
    ]("getProviderService", api.getProviderService)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.GetProviderServiceResponse.wrap)
      .provideEnvironment(r)
    def updateMatchingWorkflow(request: UpdateMatchingWorkflowRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.UpdateMatchingWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.UpdateMatchingWorkflowRequest,
      UpdateMatchingWorkflowResponse
    ]("updateMatchingWorkflow", api.updateMatchingWorkflow)(
      request.buildAwsValue()
    ).map(zio.aws.entityresolution.model.UpdateMatchingWorkflowResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def listIdMappingWorkflows(request: ListIdMappingWorkflowsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest,
      IdMappingWorkflowSummary,
      ListIdMappingWorkflowsPublisher
    ](
      "listIdMappingWorkflows",
      api.listIdMappingWorkflowsPaginator,
      _.workflowSummaries()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.entityresolution.model.IdMappingWorkflowSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listIdMappingWorkflowsPaginated(
        request: ListIdMappingWorkflowsRequest
    ): IO[
      AwsError,
      zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.ListIdMappingWorkflowsRequest,
      ListIdMappingWorkflowsResponse
    ]("listIdMappingWorkflows", api.listIdMappingWorkflows)(
      request.buildAwsValue()
    ).map(zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.wrap)
      .provideEnvironment(r)
    def getMatchId(request: GetMatchIdRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.GetMatchIdResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.GetMatchIdRequest,
      GetMatchIdResponse
    ]("getMatchId", api.getMatchId)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.GetMatchIdResponse.wrap)
      .provideEnvironment(r)
    def deleteIdMappingWorkflow(request: DeleteIdMappingWorkflowRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.DeleteIdMappingWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.DeleteIdMappingWorkflowRequest,
      DeleteIdMappingWorkflowResponse
    ]("deleteIdMappingWorkflow", api.deleteIdMappingWorkflow)(
      request.buildAwsValue()
    ).map(zio.aws.entityresolution.model.DeleteIdMappingWorkflowResponse.wrap)
      .provideEnvironment(r)
    def deleteSchemaMapping(request: DeleteSchemaMappingRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.DeleteSchemaMappingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.DeleteSchemaMappingRequest,
      DeleteSchemaMappingResponse
    ]("deleteSchemaMapping", api.deleteSchemaMapping)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.DeleteSchemaMappingResponse.wrap)
      .provideEnvironment(r)
    def getIdMappingWorkflow(request: GetIdMappingWorkflowRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.GetIdMappingWorkflowRequest,
      GetIdMappingWorkflowResponse
    ]("getIdMappingWorkflow", api.getIdMappingWorkflow)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.wrap)
      .provideEnvironment(r)
    def createMatchingWorkflow(request: CreateMatchingWorkflowRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.CreateMatchingWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.CreateMatchingWorkflowRequest,
      CreateMatchingWorkflowResponse
    ]("createMatchingWorkflow", api.createMatchingWorkflow)(
      request.buildAwsValue()
    ).map(zio.aws.entityresolution.model.CreateMatchingWorkflowResponse.wrap)
      .provideEnvironment(r)
    def listMatchingJobs(request: ListMatchingJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.entityresolution.model.JobSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest,
      JobSummary,
      ListMatchingJobsPublisher
    ]("listMatchingJobs", api.listMatchingJobsPaginator, _.jobs())(
      request.buildAwsValue()
    ).map(item => zio.aws.entityresolution.model.JobSummary.wrap(item))
      .provideEnvironment(r)
    def listMatchingJobsPaginated(request: ListMatchingJobsRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.ListMatchingJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest,
      ListMatchingJobsResponse
    ]("listMatchingJobs", api.listMatchingJobs)(request.buildAwsValue())
      .map(zio.aws.entityresolution.model.ListMatchingJobsResponse.wrap)
      .provideEnvironment(r)
    def deleteMatchingWorkflow(request: DeleteMatchingWorkflowRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.DeleteMatchingWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.DeleteMatchingWorkflowRequest,
      DeleteMatchingWorkflowResponse
    ]("deleteMatchingWorkflow", api.deleteMatchingWorkflow)(
      request.buildAwsValue()
    ).map(zio.aws.entityresolution.model.DeleteMatchingWorkflowResponse.wrap)
      .provideEnvironment(r)
    def createIdMappingWorkflow(request: CreateIdMappingWorkflowRequest): IO[
      AwsError,
      zio.aws.entityresolution.model.CreateIdMappingWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.entityresolution.model.CreateIdMappingWorkflowRequest,
      CreateIdMappingWorkflowResponse
    ]("createIdMappingWorkflow", api.createIdMappingWorkflow)(
      request.buildAwsValue()
    ).map(zio.aws.entityresolution.model.CreateIdMappingWorkflowResponse.wrap)
      .provideEnvironment(r)
  }
  def getSchemaMapping(request: GetSchemaMappingRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.GetSchemaMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSchemaMapping(request))
  def listProviderServices(request: ListProviderServicesRequest): ZStream[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.ProviderServiceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProviderServices(request))
  def listProviderServicesPaginated(request: ListProviderServicesRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.ListProviderServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProviderServicesPaginated(request))
  def getMatchingJob(request: GetMatchingJobRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.GetMatchingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMatchingJob(request))
  def getMatchingWorkflow(request: GetMatchingWorkflowRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.GetMatchingWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMatchingWorkflow(request))
  def updateSchemaMapping(request: UpdateSchemaMappingRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.UpdateSchemaMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSchemaMapping(request))
  def startIdMappingJob(request: StartIdMappingJobRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.StartIdMappingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startIdMappingJob(request))
  def listIdMappingJobs(request: ListIdMappingJobsRequest): ZStream[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.JobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listIdMappingJobs(request))
  def listIdMappingJobsPaginated(request: ListIdMappingJobsRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.ListIdMappingJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdMappingJobsPaginated(request))
  def updateIdMappingWorkflow(request: UpdateIdMappingWorkflowRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.UpdateIdMappingWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIdMappingWorkflow(request))
  def startMatchingJob(request: StartMatchingJobRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.StartMatchingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMatchingJob(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listSchemaMappings(request: ListSchemaMappingsRequest): ZStream[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.SchemaMappingSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSchemaMappings(request))
  def listSchemaMappingsPaginated(
      request: ListSchemaMappingsRequest
  ): ZIO[zio.aws.entityresolution.EntityResolution, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listSchemaMappingsPaginated(request))
  def listMatchingWorkflows(request: ListMatchingWorkflowsRequest): ZStream[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.MatchingWorkflowSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMatchingWorkflows(request))
  def listMatchingWorkflowsPaginated(
      request: ListMatchingWorkflowsRequest
  ): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.ListMatchingWorkflowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMatchingWorkflowsPaginated(request))
  def createSchemaMapping(request: CreateSchemaMappingRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.CreateSchemaMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSchemaMapping(request))
  def getIdMappingJob(request: GetIdMappingJobRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.GetIdMappingJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdMappingJob(request))
  def getProviderService(request: GetProviderServiceRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.GetProviderServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProviderService(request))
  def updateMatchingWorkflow(request: UpdateMatchingWorkflowRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.UpdateMatchingWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMatchingWorkflow(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listIdMappingWorkflows(request: ListIdMappingWorkflowsRequest): ZStream[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.IdMappingWorkflowSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listIdMappingWorkflows(request))
  def listIdMappingWorkflowsPaginated(
      request: ListIdMappingWorkflowsRequest
  ): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.ListIdMappingWorkflowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIdMappingWorkflowsPaginated(request))
  def getMatchId(request: GetMatchIdRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.GetMatchIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMatchId(request))
  def deleteIdMappingWorkflow(request: DeleteIdMappingWorkflowRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.DeleteIdMappingWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIdMappingWorkflow(request))
  def deleteSchemaMapping(request: DeleteSchemaMappingRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.DeleteSchemaMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSchemaMapping(request))
  def getIdMappingWorkflow(request: GetIdMappingWorkflowRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.GetIdMappingWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIdMappingWorkflow(request))
  def createMatchingWorkflow(request: CreateMatchingWorkflowRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.CreateMatchingWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMatchingWorkflow(request))
  def listMatchingJobs(request: ListMatchingJobsRequest): ZStream[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.JobSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listMatchingJobs(request))
  def listMatchingJobsPaginated(request: ListMatchingJobsRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.ListMatchingJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMatchingJobsPaginated(request))
  def deleteMatchingWorkflow(request: DeleteMatchingWorkflowRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.DeleteMatchingWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMatchingWorkflow(request))
  def createIdMappingWorkflow(request: CreateIdMappingWorkflowRequest): ZIO[
    zio.aws.entityresolution.EntityResolution,
    AwsError,
    zio.aws.entityresolution.model.CreateIdMappingWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIdMappingWorkflow(request))
}
