package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{JobArn, JobRunId, ApplicationId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartJobRunResponse(
    applicationId: ApplicationId,
    jobRunId: JobRunId,
    arn: JobArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.StartJobRunResponse = {
    import StartJobRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.StartJobRunResponse
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .jobRunId(JobRunId.unwrap(jobRunId): java.lang.String)
      .arn(JobArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.StartJobRunResponse.ReadOnly =
    zio.aws.emrserverless.model.StartJobRunResponse.wrap(buildAwsValue())
}
object StartJobRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.StartJobRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.StartJobRunResponse =
      zio.aws.emrserverless.model
        .StartJobRunResponse(applicationId, jobRunId, arn)
    def applicationId: ApplicationId
    def jobRunId: JobRunId
    def arn: JobArn
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getJobRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(jobRunId)
    def getArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.StartJobRunResponse
  ) extends zio.aws.emrserverless.model.StartJobRunResponse.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val jobRunId: JobRunId =
      zio.aws.emrserverless.model.primitives.JobRunId(impl.jobRunId())
    override val arn: JobArn =
      zio.aws.emrserverless.model.primitives.JobArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.StartJobRunResponse
  ): zio.aws.emrserverless.model.StartJobRunResponse.ReadOnly = new Wrapper(
    impl
  )
}
