package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{EncryptionKeyArn, UriString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3MonitoringConfiguration(
    logUri: Optional[UriString] = Optional.Absent,
    encryptionKeyArn: Optional[EncryptionKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.S3MonitoringConfiguration = {
    import S3MonitoringConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.S3MonitoringConfiguration
      .builder()
      .optionallyWith(
        logUri.map(value => UriString.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        encryptionKeyArn.map(value =>
          EncryptionKeyArn.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.S3MonitoringConfiguration.ReadOnly =
    zio.aws.emrserverless.model.S3MonitoringConfiguration.wrap(buildAwsValue())
}
object S3MonitoringConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.S3MonitoringConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.S3MonitoringConfiguration =
      zio.aws.emrserverless.model.S3MonitoringConfiguration(
        logUri.map(value => value),
        encryptionKeyArn.map(value => value)
      )
    def logUri: Optional[UriString]
    def encryptionKeyArn: Optional[EncryptionKeyArn]
    def getLogUri: ZIO[Any, AwsError, UriString] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getEncryptionKeyArn: ZIO[Any, AwsError, EncryptionKeyArn] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.S3MonitoringConfiguration
  ) extends zio.aws.emrserverless.model.S3MonitoringConfiguration.ReadOnly {
    override val logUri: Optional[UriString] = zio.aws.core.internal
      .optionalFromNullable(impl.logUri())
      .map(value => zio.aws.emrserverless.model.primitives.UriString(value))
    override val encryptionKeyArn: Optional[EncryptionKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value =>
          zio.aws.emrserverless.model.primitives.EncryptionKeyArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.S3MonitoringConfiguration
  ): zio.aws.emrserverless.model.S3MonitoringConfiguration.ReadOnly =
    new Wrapper(impl)
}
