package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{
  EngineType,
  ApplicationName,
  TagValue,
  ClientToken,
  ReleaseLabel,
  WorkerTypeString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateApplicationRequest(
    name: Optional[ApplicationName] = Optional.Absent,
    releaseLabel: ReleaseLabel,
    `type`: EngineType,
    clientToken: ClientToken,
    initialCapacity: Optional[
      Map[WorkerTypeString, zio.aws.emrserverless.model.InitialCapacityConfig]
    ] = Optional.Absent,
    maximumCapacity: Optional[
      zio.aws.emrserverless.model.MaximumAllowedResources
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    autoStartConfiguration: Optional[
      zio.aws.emrserverless.model.AutoStartConfig
    ] = Optional.Absent,
    autoStopConfiguration: Optional[
      zio.aws.emrserverless.model.AutoStopConfig
    ] = Optional.Absent,
    networkConfiguration: Optional[
      zio.aws.emrserverless.model.NetworkConfiguration
    ] = Optional.Absent,
    architecture: Optional[zio.aws.emrserverless.model.Architecture] =
      Optional.Absent,
    imageConfiguration: Optional[
      zio.aws.emrserverless.model.ImageConfigurationInput
    ] = Optional.Absent,
    workerTypeSpecifications: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput
    ]] = Optional.Absent,
    runtimeConfiguration: Optional[
      Iterable[zio.aws.emrserverless.model.Configuration]
    ] = Optional.Absent,
    monitoringConfiguration: Optional[
      zio.aws.emrserverless.model.MonitoringConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.CreateApplicationRequest
      .builder()
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .releaseLabel(ReleaseLabel.unwrap(releaseLabel): java.lang.String)
      .`type`(EngineType.unwrap(`type`): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        initialCapacity.map(value =>
          value
            .map({ case (key, value) =>
              (WorkerTypeString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.initialCapacity)
      .optionallyWith(maximumCapacity.map(value => value.buildAwsValue()))(
        _.maximumCapacity
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        autoStartConfiguration.map(value => value.buildAwsValue())
      )(_.autoStartConfiguration)
      .optionallyWith(
        autoStopConfiguration.map(value => value.buildAwsValue())
      )(_.autoStopConfiguration)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(imageConfiguration.map(value => value.buildAwsValue()))(
        _.imageConfiguration
      )
      .optionallyWith(
        workerTypeSpecifications.map(value =>
          value
            .map({ case (key, value) =>
              (WorkerTypeString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.workerTypeSpecifications)
      .optionallyWith(
        runtimeConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runtimeConfiguration)
      .optionallyWith(
        monitoringConfiguration.map(value => value.buildAwsValue())
      )(_.monitoringConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.CreateApplicationRequest.ReadOnly =
    zio.aws.emrserverless.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.CreateApplicationRequest =
      zio.aws.emrserverless.model.CreateApplicationRequest(
        name.map(value => value),
        releaseLabel,
        `type`,
        clientToken,
        initialCapacity.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maximumCapacity.map(value => value.asEditable),
        tags.map(value => value),
        autoStartConfiguration.map(value => value.asEditable),
        autoStopConfiguration.map(value => value.asEditable),
        networkConfiguration.map(value => value.asEditable),
        architecture.map(value => value),
        imageConfiguration.map(value => value.asEditable),
        workerTypeSpecifications.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        runtimeConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        monitoringConfiguration.map(value => value.asEditable)
      )
    def name: Optional[ApplicationName]
    def releaseLabel: ReleaseLabel
    def `type`: EngineType
    def clientToken: ClientToken
    def initialCapacity: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]]
    def maximumCapacity
        : Optional[zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def autoStartConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStartConfig.ReadOnly]
    def autoStopConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStopConfig.ReadOnly]
    def networkConfiguration
        : Optional[zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly]
    def architecture: Optional[zio.aws.emrserverless.model.Architecture]
    def imageConfiguration
        : Optional[zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly]
    def workerTypeSpecifications: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly
    ]]
    def runtimeConfiguration
        : Optional[List[zio.aws.emrserverless.model.Configuration.ReadOnly]]
    def monitoringConfiguration
        : Optional[zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly]
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getReleaseLabel: ZIO[Any, Nothing, ReleaseLabel] =
      ZIO.succeed(releaseLabel)
    def getType: ZIO[Any, Nothing, EngineType] = ZIO.succeed(`type`)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getInitialCapacity: ZIO[Any, AwsError, Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("initialCapacity", initialCapacity)
    def getMaximumCapacity: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly
    ] = AwsError.unwrapOptionField("maximumCapacity", maximumCapacity)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAutoStartConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.AutoStartConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoStartConfiguration",
      autoStartConfiguration
    )
    def getAutoStopConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.AutoStopConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("autoStopConfiguration", autoStopConfiguration)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.emrserverless.model.Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getImageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("imageConfiguration", imageConfiguration)
    def getWorkerTypeSpecifications: ZIO[Any, AwsError, Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "workerTypeSpecifications",
      workerTypeSpecifications
    )
    def getRuntimeConfiguration: ZIO[Any, AwsError, List[
      zio.aws.emrserverless.model.Configuration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("runtimeConfiguration", runtimeConfiguration)
    def getMonitoringConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfiguration",
      monitoringConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.CreateApplicationRequest
  ) extends zio.aws.emrserverless.model.CreateApplicationRequest.ReadOnly {
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.emrserverless.model.primitives.ApplicationName(value)
      )
    override val releaseLabel: ReleaseLabel =
      zio.aws.emrserverless.model.primitives.ReleaseLabel(impl.releaseLabel())
    override val `type`: EngineType =
      zio.aws.emrserverless.model.primitives.EngineType(impl.`type`())
    override val clientToken: ClientToken =
      zio.aws.emrserverless.model.primitives.ClientToken(impl.clientToken())
    override val initialCapacity: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.initialCapacity())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.WorkerTypeString(
              key
            ) -> zio.aws.emrserverless.model.InitialCapacityConfig.wrap(value)
          })
          .toMap
      )
    override val maximumCapacity: Optional[
      zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumCapacity())
      .map(value =>
        zio.aws.emrserverless.model.MaximumAllowedResources.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.TagKey(
              key
            ) -> zio.aws.emrserverless.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val autoStartConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStartConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoStartConfiguration())
        .map(value => zio.aws.emrserverless.model.AutoStartConfig.wrap(value))
    override val autoStopConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStopConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoStopConfiguration())
        .map(value => zio.aws.emrserverless.model.AutoStopConfig.wrap(value))
    override val networkConfiguration
        : Optional[zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value =>
          zio.aws.emrserverless.model.NetworkConfiguration.wrap(value)
        )
    override val architecture
        : Optional[zio.aws.emrserverless.model.Architecture] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.emrserverless.model.Architecture.wrap(value))
    override val imageConfiguration: Optional[
      zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageConfiguration())
      .map(value =>
        zio.aws.emrserverless.model.ImageConfigurationInput.wrap(value)
      )
    override val workerTypeSpecifications: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.workerTypeSpecifications())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.WorkerTypeString(
              key
            ) -> zio.aws.emrserverless.model.WorkerTypeSpecificationInput
              .wrap(value)
          })
          .toMap
      )
    override val runtimeConfiguration
        : Optional[List[zio.aws.emrserverless.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeConfiguration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emrserverless.model.Configuration.wrap(item)
          }.toList
        )
    override val monitoringConfiguration: Optional[
      zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringConfiguration())
      .map(value =>
        zio.aws.emrserverless.model.MonitoringConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.CreateApplicationRequest
  ): zio.aws.emrserverless.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
