package zio.aws.emrserverless
import zio.aws.emrserverless.model.primitives.{
  EntryPointArgument,
  String1024,
  SecurityGroupString,
  TagValue,
  SubnetString,
  WorkerTypeString,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.emrserverless.model.primitives.RequestIdentityUserArn.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ApplicationArn extends Subtype[String]
    type ApplicationArn =
      zio.aws.emrserverless.model.primitives.ApplicationArn.Type
    object ApplicationId extends Subtype[String]
    type ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId.Type
    object ApplicationName extends Subtype[String]
    type ApplicationName =
      zio.aws.emrserverless.model.primitives.ApplicationName.Type
    object AutoStopConfigIdleTimeoutMinutesInteger extends Subtype[Int]
    type AutoStopConfigIdleTimeoutMinutesInteger =
      zio.aws.emrserverless.model.primitives.AutoStopConfigIdleTimeoutMinutesInteger.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.emrserverless.model.primitives.ClientToken.Type
    object CpuSize extends Subtype[String]
    type CpuSize = zio.aws.emrserverless.model.primitives.CpuSize.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.emrserverless.model.primitives.Date.Type
    object DiskSize extends Subtype[String]
    type DiskSize = zio.aws.emrserverless.model.primitives.DiskSize.Type
    object Duration extends Subtype[Long]
    type Duration = zio.aws.emrserverless.model.primitives.Duration.Type
    object EncryptionKeyArn extends Subtype[String]
    type EncryptionKeyArn =
      zio.aws.emrserverless.model.primitives.EncryptionKeyArn.Type
    object EngineType extends Subtype[String]
    type EngineType = zio.aws.emrserverless.model.primitives.EngineType.Type
    object EntryPointArgument extends Subtype[String]
    type EntryPointArgument =
      zio.aws.emrserverless.model.primitives.EntryPointArgument.Type
    object EntryPointPath extends Subtype[String]
    type EntryPointPath =
      zio.aws.emrserverless.model.primitives.EntryPointPath.Type
    object HiveCliParameters extends Subtype[String]
    type HiveCliParameters =
      zio.aws.emrserverless.model.primitives.HiveCliParameters.Type
    object IAMRoleArn extends Subtype[String]
    type IAMRoleArn = zio.aws.emrserverless.model.primitives.IAMRoleArn.Type
    object ImageDigest extends Subtype[String]
    type ImageDigest = zio.aws.emrserverless.model.primitives.ImageDigest.Type
    object ImageUri extends Subtype[String]
    type ImageUri = zio.aws.emrserverless.model.primitives.ImageUri.Type
    object InitScriptPath extends Subtype[String]
    type InitScriptPath =
      zio.aws.emrserverless.model.primitives.InitScriptPath.Type
    type Integer = Int
    object JobArn extends Subtype[String]
    type JobArn = zio.aws.emrserverless.model.primitives.JobArn.Type
    object JobRunId extends Subtype[String]
    type JobRunId = zio.aws.emrserverless.model.primitives.JobRunId.Type
    object JobRunType extends Subtype[String]
    type JobRunType = zio.aws.emrserverless.model.primitives.JobRunType.Type
    object ListApplicationsRequestMaxResultsInteger extends Subtype[Int]
    type ListApplicationsRequestMaxResultsInteger =
      zio.aws.emrserverless.model.primitives.ListApplicationsRequestMaxResultsInteger.Type
    object ListJobRunsRequestMaxResultsInteger extends Subtype[Int]
    type ListJobRunsRequestMaxResultsInteger =
      zio.aws.emrserverless.model.primitives.ListJobRunsRequestMaxResultsInteger.Type
    object MemorySize extends Subtype[String]
    type MemorySize = zio.aws.emrserverless.model.primitives.MemorySize.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.emrserverless.model.primitives.NextToken.Type
    object Query extends Subtype[String]
    type Query = zio.aws.emrserverless.model.primitives.Query.Type
    object ReleaseLabel extends Subtype[String]
    type ReleaseLabel = zio.aws.emrserverless.model.primitives.ReleaseLabel.Type
    object RequestIdentityUserArn extends Subtype[String]
    type RequestIdentityUserArn =
      zio.aws.emrserverless.model.primitives.RequestIdentityUserArn.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.emrserverless.model.primitives.ResourceArn.Type
    object SecurityGroupString extends Subtype[String]
    type SecurityGroupString =
      zio.aws.emrserverless.model.primitives.SecurityGroupString.Type
    object SparkSubmitParameters extends Subtype[String]
    type SparkSubmitParameters =
      zio.aws.emrserverless.model.primitives.SparkSubmitParameters.Type
    object String1024 extends Subtype[String]
    type String1024 = zio.aws.emrserverless.model.primitives.String1024.Type
    object String256 extends Subtype[String]
    type String256 = zio.aws.emrserverless.model.primitives.String256.Type
    object SubnetString extends Subtype[String]
    type SubnetString = zio.aws.emrserverless.model.primitives.SubnetString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.emrserverless.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.emrserverless.model.primitives.TagValue.Type
    object UriString extends Subtype[String]
    type UriString = zio.aws.emrserverless.model.primitives.UriString.Type
    object Url extends Subtype[String]
    type Url = zio.aws.emrserverless.model.primitives.Url.Type
    object WorkerCounts extends Subtype[Long]
    type WorkerCounts = zio.aws.emrserverless.model.primitives.WorkerCounts.Type
    object WorkerTypeString extends Subtype[String]
    type WorkerTypeString =
      zio.aws.emrserverless.model.primitives.WorkerTypeString.Type
  }
  type ApplicationList = List[zio.aws.emrserverless.model.ApplicationSummary]
  type ApplicationStateSet = List[zio.aws.emrserverless.model.ApplicationState]
  type ConfigurationList = List[zio.aws.emrserverless.model.Configuration]
  type EntryPointArguments = List[EntryPointArgument]
  type InitialCapacityConfigMap =
    Map[WorkerTypeString, zio.aws.emrserverless.model.InitialCapacityConfig]
  type JobRunStateSet = List[zio.aws.emrserverless.model.JobRunState]
  type JobRuns = List[zio.aws.emrserverless.model.JobRunSummary]
  type SecurityGroupIds = List[SecurityGroupString]
  type SensitivePropertiesMap = Map[String1024, String1024]
  type SubnetIds = List[SubnetString]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type WorkerTypeSpecificationInputMap = Map[
    WorkerTypeString,
    zio.aws.emrserverless.model.WorkerTypeSpecificationInput
  ]
  type WorkerTypeSpecificationMap =
    Map[WorkerTypeString, zio.aws.emrserverless.model.WorkerTypeSpecification]
}
