package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.ApplicationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationRequest(applicationId: ApplicationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.DeleteApplicationRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.emrserverless.model.DeleteApplicationRequest.wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.DeleteApplicationRequest =
      zio.aws.emrserverless.model.DeleteApplicationRequest(applicationId)
    def applicationId: ApplicationId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.DeleteApplicationRequest
  ) extends zio.aws.emrserverless.model.DeleteApplicationRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.DeleteApplicationRequest
  ): zio.aws.emrserverless.model.DeleteApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
