package zio.aws.emrserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TotalResourceUtilization(
    vcpuHour: Optional[Double] = Optional.Absent,
    memoryGBHour: Optional[Double] = Optional.Absent,
    storageGBHour: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.TotalResourceUtilization = {
    import TotalResourceUtilization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.TotalResourceUtilization
      .builder()
      .optionallyWith(vcpuHour.map(value => value: java.lang.Double))(
        _.vcpuHour
      )
      .optionallyWith(memoryGBHour.map(value => value: java.lang.Double))(
        _.memoryGBHour
      )
      .optionallyWith(storageGBHour.map(value => value: java.lang.Double))(
        _.storageGBHour
      )
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.TotalResourceUtilization.ReadOnly =
    zio.aws.emrserverless.model.TotalResourceUtilization.wrap(buildAwsValue())
}
object TotalResourceUtilization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.TotalResourceUtilization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.TotalResourceUtilization =
      zio.aws.emrserverless.model.TotalResourceUtilization(
        vcpuHour.map(value => value),
        memoryGBHour.map(value => value),
        storageGBHour.map(value => value)
      )
    def vcpuHour: Optional[Double]
    def memoryGBHour: Optional[Double]
    def storageGBHour: Optional[Double]
    def getVcpuHour: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("vcpuHour", vcpuHour)
    def getMemoryGBHour: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("memoryGBHour", memoryGBHour)
    def getStorageGBHour: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("storageGBHour", storageGBHour)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.TotalResourceUtilization
  ) extends zio.aws.emrserverless.model.TotalResourceUtilization.ReadOnly {
    override val vcpuHour: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.vcpuHour())
      .map(value => value: Double)
    override val memoryGBHour: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.memoryGBHour())
      .map(value => value: Double)
    override val storageGBHour: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.storageGBHour())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.TotalResourceUtilization
  ): zio.aws.emrserverless.model.TotalResourceUtilization.ReadOnly =
    new Wrapper(impl)
}
