package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListJobRunsResponse(
    jobRuns: Iterable[zio.aws.emrserverless.model.JobRunSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ListJobRunsResponse = {
    import ListJobRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ListJobRunsResponse
      .builder()
      .jobRuns(jobRuns.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.ListJobRunsResponse.ReadOnly =
    zio.aws.emrserverless.model.ListJobRunsResponse.wrap(buildAwsValue())
}
object ListJobRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ListJobRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.ListJobRunsResponse =
      zio.aws.emrserverless.model.ListJobRunsResponse(
        jobRuns.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobRuns: List[zio.aws.emrserverless.model.JobRunSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getJobRuns: ZIO[Any, Nothing, List[
      zio.aws.emrserverless.model.JobRunSummary.ReadOnly
    ]] = ZIO.succeed(jobRuns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ListJobRunsResponse
  ) extends zio.aws.emrserverless.model.ListJobRunsResponse.ReadOnly {
    override val jobRuns
        : List[zio.aws.emrserverless.model.JobRunSummary.ReadOnly] = impl
      .jobRuns()
      .asScala
      .map { item =>
        zio.aws.emrserverless.model.JobRunSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.emrserverless.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ListJobRunsResponse
  ): zio.aws.emrserverless.model.ListJobRunsResponse.ReadOnly = new Wrapper(
    impl
  )
}
