package zio.aws.emrserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetApplicationResponse(
    application: zio.aws.emrserverless.model.Application
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.GetApplicationResponse = {
    import GetApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.GetApplicationResponse
      .builder()
      .application(application.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.GetApplicationResponse.ReadOnly =
    zio.aws.emrserverless.model.GetApplicationResponse.wrap(buildAwsValue())
}
object GetApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.GetApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.GetApplicationResponse =
      zio.aws.emrserverless.model.GetApplicationResponse(application.asEditable)
    def application: zio.aws.emrserverless.model.Application.ReadOnly
    def getApplication
        : ZIO[Any, Nothing, zio.aws.emrserverless.model.Application.ReadOnly] =
      ZIO.succeed(application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.GetApplicationResponse
  ) extends zio.aws.emrserverless.model.GetApplicationResponse.ReadOnly {
    override val application: zio.aws.emrserverless.model.Application.ReadOnly =
      zio.aws.emrserverless.model.Application.wrap(impl.application())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.GetApplicationResponse
  ): zio.aws.emrserverless.model.GetApplicationResponse.ReadOnly = new Wrapper(
    impl
  )
}
