package zio.aws.emrserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkerTypeSpecificationInput(
    imageConfiguration: Optional[
      zio.aws.emrserverless.model.ImageConfigurationInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.WorkerTypeSpecificationInput = {
    import WorkerTypeSpecificationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.WorkerTypeSpecificationInput
      .builder()
      .optionallyWith(imageConfiguration.map(value => value.buildAwsValue()))(
        _.imageConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly =
    zio.aws.emrserverless.model.WorkerTypeSpecificationInput
      .wrap(buildAwsValue())
}
object WorkerTypeSpecificationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.WorkerTypeSpecificationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.WorkerTypeSpecificationInput =
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput(
        imageConfiguration.map(value => value.asEditable)
      )
    def imageConfiguration
        : Optional[zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly]
    def getImageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("imageConfiguration", imageConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.WorkerTypeSpecificationInput
  ) extends zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly {
    override val imageConfiguration: Optional[
      zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageConfiguration())
      .map(value =>
        zio.aws.emrserverless.model.ImageConfigurationInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.WorkerTypeSpecificationInput
  ): zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly =
    new Wrapper(impl)
}
