package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.EncryptionKeyArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ManagedPersistenceMonitoringConfiguration(
    enabled: Optional[Boolean] = Optional.Absent,
    encryptionKeyArn: Optional[EncryptionKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ManagedPersistenceMonitoringConfiguration = {
    import ManagedPersistenceMonitoringConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ManagedPersistenceMonitoringConfiguration
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        encryptionKeyArn.map(value =>
          EncryptionKeyArn.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration.ReadOnly =
    zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration
      .wrap(buildAwsValue())
}
object ManagedPersistenceMonitoringConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ManagedPersistenceMonitoringConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration =
      zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration(
        enabled.map(value => value),
        encryptionKeyArn.map(value => value)
      )
    def enabled: Optional[Boolean]
    def encryptionKeyArn: Optional[EncryptionKeyArn]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEncryptionKeyArn: ZIO[Any, AwsError, EncryptionKeyArn] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ManagedPersistenceMonitoringConfiguration
  ) extends zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val encryptionKeyArn: Optional[EncryptionKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value =>
          zio.aws.emrserverless.model.primitives.EncryptionKeyArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ManagedPersistenceMonitoringConfiguration
  ): zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration.ReadOnly =
    new Wrapper(impl)
}
