package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{
  SecurityGroupString,
  SubnetString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkConfiguration(
    subnetIds: Optional[Iterable[SubnetString]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.NetworkConfiguration = {
    import NetworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.NetworkConfiguration
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly =
    zio.aws.emrserverless.model.NetworkConfiguration.wrap(buildAwsValue())
}
object NetworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.NetworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.NetworkConfiguration =
      zio.aws.emrserverless.model.NetworkConfiguration(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value)
      )
    def subnetIds: Optional[List[SubnetString]]
    def securityGroupIds: Optional[List[SecurityGroupString]]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetString]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.NetworkConfiguration
  ) extends zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly {
    override val subnetIds: Optional[List[SubnetString]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emrserverless.model.primitives.SubnetString(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[SecurityGroupString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emrserverless.model.primitives.SecurityGroupString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.NetworkConfiguration
  ): zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
