package zio.aws.emrserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emrserverless.model.primitives.{
  IAMRoleArn,
  JobRunId,
  Date,
  JobArn,
  ReleaseLabel,
  RequestIdentityUserArn,
  JobRunType,
  ApplicationId,
  String256
}
import scala.jdk.CollectionConverters.*
final case class JobRunSummary(
    applicationId: ApplicationId,
    id: JobRunId,
    name: Optional[String256] = Optional.Absent,
    arn: JobArn,
    createdBy: RequestIdentityUserArn,
    createdAt: Date,
    updatedAt: Date,
    executionRole: IAMRoleArn,
    state: zio.aws.emrserverless.model.JobRunState,
    stateDetails: String256,
    releaseLabel: ReleaseLabel,
    `type`: Optional[JobRunType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.JobRunSummary = {
    import JobRunSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.JobRunSummary
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .id(JobRunId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => String256.unwrap(value): java.lang.String)
      )(_.name)
      .arn(JobArn.unwrap(arn): java.lang.String)
      .createdBy(RequestIdentityUserArn.unwrap(createdBy): java.lang.String)
      .createdAt(Date.unwrap(createdAt): Instant)
      .updatedAt(Date.unwrap(updatedAt): Instant)
      .executionRole(IAMRoleArn.unwrap(executionRole): java.lang.String)
      .state(state.unwrap)
      .stateDetails(String256.unwrap(stateDetails): java.lang.String)
      .releaseLabel(ReleaseLabel.unwrap(releaseLabel): java.lang.String)
      .optionallyWith(
        `type`.map(value => JobRunType.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.JobRunSummary.ReadOnly =
    zio.aws.emrserverless.model.JobRunSummary.wrap(buildAwsValue())
}
object JobRunSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.JobRunSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.JobRunSummary =
      zio.aws.emrserverless.model.JobRunSummary(
        applicationId,
        id,
        name.map(value => value),
        arn,
        createdBy,
        createdAt,
        updatedAt,
        executionRole,
        state,
        stateDetails,
        releaseLabel,
        `type`.map(value => value)
      )
    def applicationId: ApplicationId
    def id: JobRunId
    def name: Optional[String256]
    def arn: JobArn
    def createdBy: RequestIdentityUserArn
    def createdAt: Date
    def updatedAt: Date
    def executionRole: IAMRoleArn
    def state: zio.aws.emrserverless.model.JobRunState
    def stateDetails: String256
    def releaseLabel: ReleaseLabel
    def `type`: Optional[JobRunType]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(arn)
    def getCreatedBy: ZIO[Any, Nothing, RequestIdentityUserArn] =
      ZIO.succeed(createdBy)
    def getCreatedAt: ZIO[Any, Nothing, Date] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Date] = ZIO.succeed(updatedAt)
    def getExecutionRole: ZIO[Any, Nothing, IAMRoleArn] =
      ZIO.succeed(executionRole)
    def getState: ZIO[Any, Nothing, zio.aws.emrserverless.model.JobRunState] =
      ZIO.succeed(state)
    def getStateDetails: ZIO[Any, Nothing, String256] =
      ZIO.succeed(stateDetails)
    def getReleaseLabel: ZIO[Any, Nothing, ReleaseLabel] =
      ZIO.succeed(releaseLabel)
    def getType: ZIO[Any, AwsError, JobRunType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.JobRunSummary
  ) extends zio.aws.emrserverless.model.JobRunSummary.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val id: JobRunId =
      zio.aws.emrserverless.model.primitives.JobRunId(impl.id())
    override val name: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emrserverless.model.primitives.String256(value))
    override val arn: JobArn =
      zio.aws.emrserverless.model.primitives.JobArn(impl.arn())
    override val createdBy: RequestIdentityUserArn =
      zio.aws.emrserverless.model.primitives
        .RequestIdentityUserArn(impl.createdBy())
    override val createdAt: Date =
      zio.aws.emrserverless.model.primitives.Date(impl.createdAt())
    override val updatedAt: Date =
      zio.aws.emrserverless.model.primitives.Date(impl.updatedAt())
    override val executionRole: IAMRoleArn =
      zio.aws.emrserverless.model.primitives.IAMRoleArn(impl.executionRole())
    override val state: zio.aws.emrserverless.model.JobRunState =
      zio.aws.emrserverless.model.JobRunState.wrap(impl.state())
    override val stateDetails: String256 =
      zio.aws.emrserverless.model.primitives.String256(impl.stateDetails())
    override val releaseLabel: ReleaseLabel =
      zio.aws.emrserverless.model.primitives.ReleaseLabel(impl.releaseLabel())
    override val `type`: Optional[JobRunType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.emrserverless.model.primitives.JobRunType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.JobRunSummary
  ): zio.aws.emrserverless.model.JobRunSummary.ReadOnly = new Wrapper(impl)
}
