package zio.aws.emrserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JobDriver(
    sparkSubmit: Optional[zio.aws.emrserverless.model.SparkSubmit] =
      Optional.Absent,
    hive: Optional[zio.aws.emrserverless.model.Hive] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.JobDriver = {
    import JobDriver.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.JobDriver
      .builder()
      .optionallyWith(sparkSubmit.map(value => value.buildAwsValue()))(
        _.sparkSubmit
      )
      .optionallyWith(hive.map(value => value.buildAwsValue()))(_.hive)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.JobDriver.ReadOnly =
    zio.aws.emrserverless.model.JobDriver.wrap(buildAwsValue())
}
object JobDriver {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.JobDriver
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.JobDriver =
      zio.aws.emrserverless.model.JobDriver(
        sparkSubmit.map(value => value.asEditable),
        hive.map(value => value.asEditable)
      )
    def sparkSubmit: Optional[zio.aws.emrserverless.model.SparkSubmit.ReadOnly]
    def hive: Optional[zio.aws.emrserverless.model.Hive.ReadOnly]
    def getSparkSubmit
        : ZIO[Any, AwsError, zio.aws.emrserverless.model.SparkSubmit.ReadOnly] =
      AwsError.unwrapOptionField("sparkSubmit", sparkSubmit)
    def getHive: ZIO[Any, AwsError, zio.aws.emrserverless.model.Hive.ReadOnly] =
      AwsError.unwrapOptionField("hive", hive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.JobDriver
  ) extends zio.aws.emrserverless.model.JobDriver.ReadOnly {
    override val sparkSubmit
        : Optional[zio.aws.emrserverless.model.SparkSubmit.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sparkSubmit())
        .map(value => zio.aws.emrserverless.model.SparkSubmit.wrap(value))
    override val hive: Optional[zio.aws.emrserverless.model.Hive.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hive())
        .map(value => zio.aws.emrserverless.model.Hive.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.JobDriver
  ): zio.aws.emrserverless.model.JobDriver.ReadOnly = new Wrapper(impl)
}
