package zio.aws.emrserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationResponse(
    application: zio.aws.emrserverless.model.Application
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.UpdateApplicationResponse = {
    import UpdateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.UpdateApplicationResponse
      .builder()
      .application(application.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.UpdateApplicationResponse.ReadOnly =
    zio.aws.emrserverless.model.UpdateApplicationResponse.wrap(buildAwsValue())
}
object UpdateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.UpdateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.UpdateApplicationResponse =
      zio.aws.emrserverless.model
        .UpdateApplicationResponse(application.asEditable)
    def application: zio.aws.emrserverless.model.Application.ReadOnly
    def getApplication
        : ZIO[Any, Nothing, zio.aws.emrserverless.model.Application.ReadOnly] =
      ZIO.succeed(application)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.UpdateApplicationResponse
  ) extends zio.aws.emrserverless.model.UpdateApplicationResponse.ReadOnly {
    override val application: zio.aws.emrserverless.model.Application.ReadOnly =
      zio.aws.emrserverless.model.Application.wrap(impl.application())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.UpdateApplicationResponse
  ): zio.aws.emrserverless.model.UpdateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
