package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.ApplicationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopApplicationRequest(applicationId: ApplicationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.StopApplicationRequest = {
    import StopApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.StopApplicationRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.StopApplicationRequest.ReadOnly =
    zio.aws.emrserverless.model.StopApplicationRequest.wrap(buildAwsValue())
}
object StopApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.StopApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.StopApplicationRequest =
      zio.aws.emrserverless.model.StopApplicationRequest(applicationId)
    def applicationId: ApplicationId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.StopApplicationRequest
  ) extends zio.aws.emrserverless.model.StopApplicationRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.StopApplicationRequest
  ): zio.aws.emrserverless.model.StopApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
