package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.ApplicationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartApplicationRequest(applicationId: ApplicationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.StartApplicationRequest = {
    import StartApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.StartApplicationRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.StartApplicationRequest.ReadOnly =
    zio.aws.emrserverless.model.StartApplicationRequest.wrap(buildAwsValue())
}
object StartApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.StartApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.StartApplicationRequest =
      zio.aws.emrserverless.model.StartApplicationRequest(applicationId)
    def applicationId: ApplicationId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.StartApplicationRequest
  ) extends zio.aws.emrserverless.model.StartApplicationRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.StartApplicationRequest
  ): zio.aws.emrserverless.model.StartApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
