package zio.aws.emrserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MonitoringConfiguration(
    s3MonitoringConfiguration: Optional[
      zio.aws.emrserverless.model.S3MonitoringConfiguration
    ] = Optional.Absent,
    managedPersistenceMonitoringConfiguration: Optional[
      zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.MonitoringConfiguration = {
    import MonitoringConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.MonitoringConfiguration
      .builder()
      .optionallyWith(
        s3MonitoringConfiguration.map(value => value.buildAwsValue())
      )(_.s3MonitoringConfiguration)
      .optionallyWith(
        managedPersistenceMonitoringConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.managedPersistenceMonitoringConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly =
    zio.aws.emrserverless.model.MonitoringConfiguration.wrap(buildAwsValue())
}
object MonitoringConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.MonitoringConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.MonitoringConfiguration =
      zio.aws.emrserverless.model.MonitoringConfiguration(
        s3MonitoringConfiguration.map(value => value.asEditable),
        managedPersistenceMonitoringConfiguration.map(value => value.asEditable)
      )
    def s3MonitoringConfiguration: Optional[
      zio.aws.emrserverless.model.S3MonitoringConfiguration.ReadOnly
    ]
    def managedPersistenceMonitoringConfiguration: Optional[
      zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration.ReadOnly
    ]
    def getS3MonitoringConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.S3MonitoringConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3MonitoringConfiguration",
      s3MonitoringConfiguration
    )
    def getManagedPersistenceMonitoringConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "managedPersistenceMonitoringConfiguration",
      managedPersistenceMonitoringConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.MonitoringConfiguration
  ) extends zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly {
    override val s3MonitoringConfiguration: Optional[
      zio.aws.emrserverless.model.S3MonitoringConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3MonitoringConfiguration())
      .map(value =>
        zio.aws.emrserverless.model.S3MonitoringConfiguration.wrap(value)
      )
    override val managedPersistenceMonitoringConfiguration: Optional[
      zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.managedPersistenceMonitoringConfiguration())
      .map(value =>
        zio.aws.emrserverless.model.ManagedPersistenceMonitoringConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.MonitoringConfiguration
  ): zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
