package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListApplicationsResponse(
    applications: Iterable[zio.aws.emrserverless.model.ApplicationSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ListApplicationsResponse
      .builder()
      .applications(applications.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.ListApplicationsResponse.ReadOnly =
    zio.aws.emrserverless.model.ListApplicationsResponse.wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.ListApplicationsResponse =
      zio.aws.emrserverless.model.ListApplicationsResponse(
        applications.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def applications
        : List[zio.aws.emrserverless.model.ApplicationSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getApplications: ZIO[Any, Nothing, List[
      zio.aws.emrserverless.model.ApplicationSummary.ReadOnly
    ]] = ZIO.succeed(applications)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ListApplicationsResponse
  ) extends zio.aws.emrserverless.model.ListApplicationsResponse.ReadOnly {
    override val applications
        : List[zio.aws.emrserverless.model.ApplicationSummary.ReadOnly] = impl
      .applications()
      .asScala
      .map { item =>
        zio.aws.emrserverless.model.ApplicationSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.emrserverless.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ListApplicationsResponse
  ): zio.aws.emrserverless.model.ListApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
