package zio.aws.emrserverless.model
import scala.jdk.CollectionConverters.*
sealed trait JobRunState {
  def unwrap: software.amazon.awssdk.services.emrserverless.model.JobRunState
}
object JobRunState {
  def wrap(
      value: software.amazon.awssdk.services.emrserverless.model.JobRunState
  ): zio.aws.emrserverless.model.JobRunState = value match {
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.SCHEDULED =>
      val r = SCHEDULED
      r
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.emrserverless.model.JobRunState.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.SUBMITTED
  }
  case object PENDING extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.PENDING
  }
  case object SCHEDULED extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.SCHEDULED
  }
  case object RUNNING extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.RUNNING
  }
  case object SUCCESS extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.SUCCESS
  }
  case object FAILED extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.FAILED
  }
  case object CANCELLING extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.CANCELLING
  }
  case object CANCELLED extends zio.aws.emrserverless.model.JobRunState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.JobRunState =
      software.amazon.awssdk.services.emrserverless.model.JobRunState.CANCELLED
  }
}
