package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.ApplicationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetApplicationRequest(applicationId: ApplicationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.GetApplicationRequest = {
    import GetApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.GetApplicationRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.GetApplicationRequest.ReadOnly =
    zio.aws.emrserverless.model.GetApplicationRequest.wrap(buildAwsValue())
}
object GetApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.GetApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.GetApplicationRequest =
      zio.aws.emrserverless.model.GetApplicationRequest(applicationId)
    def applicationId: ApplicationId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.GetApplicationRequest
  ) extends zio.aws.emrserverless.model.GetApplicationRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.GetApplicationRequest
  ): zio.aws.emrserverless.model.GetApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
