package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.String1024
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Configuration(
    classification: String1024,
    properties: Optional[Map[String1024, String1024]] = Optional.Absent,
    configurations: Optional[
      Iterable[zio.aws.emrserverless.model.Configuration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.Configuration = {
    import Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.Configuration
      .builder()
      .classification(String1024.unwrap(classification): java.lang.String)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (String1024.unwrap(key): java.lang.String) -> (String1024
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.properties)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.Configuration.ReadOnly =
    zio.aws.emrserverless.model.Configuration.wrap(buildAwsValue())
}
object Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.Configuration =
      zio.aws.emrserverless.model.Configuration(
        classification,
        properties.map(value => value),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def classification: String1024
    def properties: Optional[Map[String1024, String1024]]
    def configurations
        : Optional[List[zio.aws.emrserverless.model.Configuration.ReadOnly]]
    def getClassification: ZIO[Any, Nothing, String1024] =
      ZIO.succeed(classification)
    def getProperties: ZIO[Any, AwsError, Map[String1024, String1024]] =
      AwsError.unwrapOptionField("properties", properties)
    def getConfigurations: ZIO[Any, AwsError, List[
      zio.aws.emrserverless.model.Configuration.ReadOnly
    ]] = AwsError.unwrapOptionField("configurations", configurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.Configuration
  ) extends zio.aws.emrserverless.model.Configuration.ReadOnly {
    override val classification: String1024 =
      zio.aws.emrserverless.model.primitives.String1024(impl.classification())
    override val properties: Optional[Map[String1024, String1024]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.emrserverless.model.primitives.String1024(
                key
              ) -> zio.aws.emrserverless.model.primitives.String1024(value)
            })
            .toMap
        )
    override val configurations
        : Optional[List[zio.aws.emrserverless.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emrserverless.model.Configuration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.Configuration
  ): zio.aws.emrserverless.model.Configuration.ReadOnly = new Wrapper(impl)
}
