package zio.aws.emrserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emrserverless.model.primitives.{
  EngineType,
  Date,
  ApplicationName,
  TagValue,
  ApplicationArn,
  ReleaseLabel,
  WorkerTypeString,
  ApplicationId,
  String256,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class Application(
    applicationId: ApplicationId,
    name: Optional[ApplicationName] = Optional.Absent,
    arn: ApplicationArn,
    releaseLabel: ReleaseLabel,
    `type`: EngineType,
    state: zio.aws.emrserverless.model.ApplicationState,
    stateDetails: Optional[String256] = Optional.Absent,
    initialCapacity: Optional[
      Map[WorkerTypeString, zio.aws.emrserverless.model.InitialCapacityConfig]
    ] = Optional.Absent,
    maximumCapacity: Optional[
      zio.aws.emrserverless.model.MaximumAllowedResources
    ] = Optional.Absent,
    createdAt: Date,
    updatedAt: Date,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    autoStartConfiguration: Optional[
      zio.aws.emrserverless.model.AutoStartConfig
    ] = Optional.Absent,
    autoStopConfiguration: Optional[
      zio.aws.emrserverless.model.AutoStopConfig
    ] = Optional.Absent,
    networkConfiguration: Optional[
      zio.aws.emrserverless.model.NetworkConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.Application = {
    import Application.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.Application
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .arn(ApplicationArn.unwrap(arn): java.lang.String)
      .releaseLabel(ReleaseLabel.unwrap(releaseLabel): java.lang.String)
      .`type`(EngineType.unwrap(`type`): java.lang.String)
      .state(state.unwrap)
      .optionallyWith(
        stateDetails.map(value => String256.unwrap(value): java.lang.String)
      )(_.stateDetails)
      .optionallyWith(
        initialCapacity.map(value =>
          value
            .map({ case (key, value) =>
              (WorkerTypeString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.initialCapacity)
      .optionallyWith(maximumCapacity.map(value => value.buildAwsValue()))(
        _.maximumCapacity
      )
      .createdAt(Date.unwrap(createdAt): Instant)
      .updatedAt(Date.unwrap(updatedAt): Instant)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        autoStartConfiguration.map(value => value.buildAwsValue())
      )(_.autoStartConfiguration)
      .optionallyWith(
        autoStopConfiguration.map(value => value.buildAwsValue())
      )(_.autoStopConfiguration)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.Application.ReadOnly =
    zio.aws.emrserverless.model.Application.wrap(buildAwsValue())
}
object Application {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.Application
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.Application =
      zio.aws.emrserverless.model.Application(
        applicationId,
        name.map(value => value),
        arn,
        releaseLabel,
        `type`,
        state,
        stateDetails.map(value => value),
        initialCapacity.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maximumCapacity.map(value => value.asEditable),
        createdAt,
        updatedAt,
        tags.map(value => value),
        autoStartConfiguration.map(value => value.asEditable),
        autoStopConfiguration.map(value => value.asEditable),
        networkConfiguration.map(value => value.asEditable)
      )
    def applicationId: ApplicationId
    def name: Optional[ApplicationName]
    def arn: ApplicationArn
    def releaseLabel: ReleaseLabel
    def `type`: EngineType
    def state: zio.aws.emrserverless.model.ApplicationState
    def stateDetails: Optional[String256]
    def initialCapacity: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]]
    def maximumCapacity
        : Optional[zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly]
    def createdAt: Date
    def updatedAt: Date
    def tags: Optional[Map[TagKey, TagValue]]
    def autoStartConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStartConfig.ReadOnly]
    def autoStopConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStopConfig.ReadOnly]
    def networkConfiguration
        : Optional[zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, Nothing, ApplicationArn] = ZIO.succeed(arn)
    def getReleaseLabel: ZIO[Any, Nothing, ReleaseLabel] =
      ZIO.succeed(releaseLabel)
    def getType: ZIO[Any, Nothing, EngineType] = ZIO.succeed(`type`)
    def getState
        : ZIO[Any, Nothing, zio.aws.emrserverless.model.ApplicationState] =
      ZIO.succeed(state)
    def getStateDetails: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("stateDetails", stateDetails)
    def getInitialCapacity: ZIO[Any, AwsError, Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("initialCapacity", initialCapacity)
    def getMaximumCapacity: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly
    ] = AwsError.unwrapOptionField("maximumCapacity", maximumCapacity)
    def getCreatedAt: ZIO[Any, Nothing, Date] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Date] = ZIO.succeed(updatedAt)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAutoStartConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.AutoStartConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoStartConfiguration",
      autoStartConfiguration
    )
    def getAutoStopConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.AutoStopConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("autoStopConfiguration", autoStopConfiguration)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.Application
  ) extends zio.aws.emrserverless.model.Application.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.emrserverless.model.primitives.ApplicationName(value)
      )
    override val arn: ApplicationArn =
      zio.aws.emrserverless.model.primitives.ApplicationArn(impl.arn())
    override val releaseLabel: ReleaseLabel =
      zio.aws.emrserverless.model.primitives.ReleaseLabel(impl.releaseLabel())
    override val `type`: EngineType =
      zio.aws.emrserverless.model.primitives.EngineType(impl.`type`())
    override val state: zio.aws.emrserverless.model.ApplicationState =
      zio.aws.emrserverless.model.ApplicationState.wrap(impl.state())
    override val stateDetails: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.stateDetails())
      .map(value => zio.aws.emrserverless.model.primitives.String256(value))
    override val initialCapacity: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.initialCapacity())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.WorkerTypeString(
              key
            ) -> zio.aws.emrserverless.model.InitialCapacityConfig.wrap(value)
          })
          .toMap
      )
    override val maximumCapacity: Optional[
      zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumCapacity())
      .map(value =>
        zio.aws.emrserverless.model.MaximumAllowedResources.wrap(value)
      )
    override val createdAt: Date =
      zio.aws.emrserverless.model.primitives.Date(impl.createdAt())
    override val updatedAt: Date =
      zio.aws.emrserverless.model.primitives.Date(impl.updatedAt())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.TagKey(
              key
            ) -> zio.aws.emrserverless.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val autoStartConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStartConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoStartConfiguration())
        .map(value => zio.aws.emrserverless.model.AutoStartConfig.wrap(value))
    override val autoStopConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStopConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoStopConfiguration())
        .map(value => zio.aws.emrserverless.model.AutoStopConfig.wrap(value))
    override val networkConfiguration
        : Optional[zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value =>
          zio.aws.emrserverless.model.NetworkConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.Application
  ): zio.aws.emrserverless.model.Application.ReadOnly = new Wrapper(impl)
}
