package zio.aws.emrserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emrserverless.model.primitives.AutoStopConfigIdleTimeoutMinutesInteger
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AutoStopConfig(
    enabled: Optional[Boolean] = Optional.Absent,
    idleTimeoutMinutes: Optional[AutoStopConfigIdleTimeoutMinutesInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.AutoStopConfig = {
    import AutoStopConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.AutoStopConfig
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        idleTimeoutMinutes.map(value =>
          AutoStopConfigIdleTimeoutMinutesInteger.unwrap(value): Integer
        )
      )(_.idleTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.AutoStopConfig.ReadOnly =
    zio.aws.emrserverless.model.AutoStopConfig.wrap(buildAwsValue())
}
object AutoStopConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.AutoStopConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.AutoStopConfig =
      zio.aws.emrserverless.model.AutoStopConfig(
        enabled.map(value => value),
        idleTimeoutMinutes.map(value => value)
      )
    def enabled: Optional[Boolean]
    def idleTimeoutMinutes: Optional[AutoStopConfigIdleTimeoutMinutesInteger]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIdleTimeoutMinutes
        : ZIO[Any, AwsError, AutoStopConfigIdleTimeoutMinutesInteger] =
      AwsError.unwrapOptionField("idleTimeoutMinutes", idleTimeoutMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.AutoStopConfig
  ) extends zio.aws.emrserverless.model.AutoStopConfig.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val idleTimeoutMinutes
        : Optional[AutoStopConfigIdleTimeoutMinutesInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idleTimeoutMinutes())
        .map(value =>
          zio.aws.emrserverless.model.primitives
            .AutoStopConfigIdleTimeoutMinutesInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.AutoStopConfig
  ): zio.aws.emrserverless.model.AutoStopConfig.ReadOnly = new Wrapper(impl)
}
