package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{
  LogTypeString,
  LogGroupName,
  EncryptionKeyArn,
  LogStreamNamePrefix,
  WorkerTypeString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudWatchLoggingConfiguration(
    enabled: Boolean,
    logGroupName: Optional[LogGroupName] = Optional.Absent,
    logStreamNamePrefix: Optional[LogStreamNamePrefix] = Optional.Absent,
    encryptionKeyArn: Optional[EncryptionKeyArn] = Optional.Absent,
    logTypes: Optional[Map[WorkerTypeString, Iterable[LogTypeString]]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.CloudWatchLoggingConfiguration = {
    import CloudWatchLoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.CloudWatchLoggingConfiguration
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        logGroupName.map(value => LogGroupName.unwrap(value): java.lang.String)
      )(_.logGroupName)
      .optionallyWith(
        logStreamNamePrefix.map(value =>
          LogStreamNamePrefix.unwrap(value): java.lang.String
        )
      )(_.logStreamNamePrefix)
      .optionallyWith(
        encryptionKeyArn.map(value =>
          EncryptionKeyArn.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .optionallyWith(
        logTypes.map(value =>
          value
            .map({ case (key, value) =>
              (WorkerTypeString.unwrap(key): java.lang.String) -> value.map {
                item =>
                  LogTypeString.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.logTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.CloudWatchLoggingConfiguration.ReadOnly =
    zio.aws.emrserverless.model.CloudWatchLoggingConfiguration
      .wrap(buildAwsValue())
}
object CloudWatchLoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.CloudWatchLoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.CloudWatchLoggingConfiguration =
      zio.aws.emrserverless.model.CloudWatchLoggingConfiguration(
        enabled,
        logGroupName.map(value => value),
        logStreamNamePrefix.map(value => value),
        encryptionKeyArn.map(value => value),
        logTypes.map(value => value)
      )
    def enabled: Boolean
    def logGroupName: Optional[LogGroupName]
    def logStreamNamePrefix: Optional[LogStreamNamePrefix]
    def encryptionKeyArn: Optional[EncryptionKeyArn]
    def logTypes: Optional[Map[WorkerTypeString, List[LogTypeString]]]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getLogGroupName: ZIO[Any, AwsError, LogGroupName] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getLogStreamNamePrefix: ZIO[Any, AwsError, LogStreamNamePrefix] =
      AwsError.unwrapOptionField("logStreamNamePrefix", logStreamNamePrefix)
    def getEncryptionKeyArn: ZIO[Any, AwsError, EncryptionKeyArn] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getLogTypes
        : ZIO[Any, AwsError, Map[WorkerTypeString, List[LogTypeString]]] =
      AwsError.unwrapOptionField("logTypes", logTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.CloudWatchLoggingConfiguration
  ) extends zio.aws.emrserverless.model.CloudWatchLoggingConfiguration.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val logGroupName: Optional[LogGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupName())
      .map(value => zio.aws.emrserverless.model.primitives.LogGroupName(value))
    override val logStreamNamePrefix: Optional[LogStreamNamePrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logStreamNamePrefix())
        .map(value =>
          zio.aws.emrserverless.model.primitives.LogStreamNamePrefix(value)
        )
    override val encryptionKeyArn: Optional[EncryptionKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value =>
          zio.aws.emrserverless.model.primitives.EncryptionKeyArn(value)
        )
    override val logTypes
        : Optional[Map[WorkerTypeString, List[LogTypeString]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logTypes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.emrserverless.model.primitives
                .WorkerTypeString(key) -> value.asScala.map { item =>
                zio.aws.emrserverless.model.primitives.LogTypeString(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.CloudWatchLoggingConfiguration
  ): zio.aws.emrserverless.model.CloudWatchLoggingConfiguration.ReadOnly =
    new Wrapper(impl)
}
