package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{ImageDigest, ImageUri}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageConfiguration(
    imageUri: ImageUri,
    resolvedImageDigest: Optional[ImageDigest] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ImageConfiguration = {
    import ImageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ImageConfiguration
      .builder()
      .imageUri(ImageUri.unwrap(imageUri): java.lang.String)
      .optionallyWith(
        resolvedImageDigest.map(value =>
          ImageDigest.unwrap(value): java.lang.String
        )
      )(_.resolvedImageDigest)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.ImageConfiguration.ReadOnly =
    zio.aws.emrserverless.model.ImageConfiguration.wrap(buildAwsValue())
}
object ImageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ImageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.ImageConfiguration =
      zio.aws.emrserverless.model
        .ImageConfiguration(imageUri, resolvedImageDigest.map(value => value))
    def imageUri: ImageUri
    def resolvedImageDigest: Optional[ImageDigest]
    def getImageUri: ZIO[Any, Nothing, ImageUri] = ZIO.succeed(imageUri)
    def getResolvedImageDigest: ZIO[Any, AwsError, ImageDigest] =
      AwsError.unwrapOptionField("resolvedImageDigest", resolvedImageDigest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ImageConfiguration
  ) extends zio.aws.emrserverless.model.ImageConfiguration.ReadOnly {
    override val imageUri: ImageUri =
      zio.aws.emrserverless.model.primitives.ImageUri(impl.imageUri())
    override val resolvedImageDigest: Optional[ImageDigest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolvedImageDigest())
        .map(value => zio.aws.emrserverless.model.primitives.ImageDigest(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ImageConfiguration
  ): zio.aws.emrserverless.model.ImageConfiguration.ReadOnly = new Wrapper(impl)
}
