package zio.aws.emrserverless.model
import scala.jdk.CollectionConverters._
sealed trait Architecture {
  def unwrap: software.amazon.awssdk.services.emrserverless.model.Architecture
}
object Architecture {
  def wrap(
      value: software.amazon.awssdk.services.emrserverless.model.Architecture
  ): zio.aws.emrserverless.model.Architecture = value match {
    case software.amazon.awssdk.services.emrserverless.model.Architecture.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emrserverless.model.Architecture.ARM64 =>
      val r = ARM64
      r
    case software.amazon.awssdk.services.emrserverless.model.Architecture.X86_64 =>
      val r = X86_64
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emrserverless.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.Architecture =
      software.amazon.awssdk.services.emrserverless.model.Architecture.UNKNOWN_TO_SDK_VERSION
  }
  case object ARM64 extends zio.aws.emrserverless.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.Architecture =
      software.amazon.awssdk.services.emrserverless.model.Architecture.ARM64
  }
  case object X86_64 extends zio.aws.emrserverless.model.Architecture {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.Architecture =
      software.amazon.awssdk.services.emrserverless.model.Architecture.X86_64
  }
}
