package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.WorkerCounts
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InitialCapacityConfig(
    workerCount: WorkerCounts,
    workerConfiguration: Optional[
      zio.aws.emrserverless.model.WorkerResourceConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfig = {
    import InitialCapacityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfig
      .builder()
      .workerCount(WorkerCounts.unwrap(workerCount): java.lang.Long)
      .optionallyWith(workerConfiguration.map(value => value.buildAwsValue()))(
        _.workerConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly =
    zio.aws.emrserverless.model.InitialCapacityConfig.wrap(buildAwsValue())
}
object InitialCapacityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.InitialCapacityConfig =
      zio.aws.emrserverless.model.InitialCapacityConfig(
        workerCount,
        workerConfiguration.map(value => value.asEditable)
      )
    def workerCount: WorkerCounts
    def workerConfiguration
        : Optional[zio.aws.emrserverless.model.WorkerResourceConfig.ReadOnly]
    def getWorkerCount: ZIO[Any, Nothing, WorkerCounts] =
      ZIO.succeed(workerCount)
    def getWorkerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.WorkerResourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("workerConfiguration", workerConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfig
  ) extends zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly {
    override val workerCount: WorkerCounts =
      zio.aws.emrserverless.model.primitives.WorkerCounts(impl.workerCount())
    override val workerConfiguration
        : Optional[zio.aws.emrserverless.model.WorkerResourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workerConfiguration())
        .map(value =>
          zio.aws.emrserverless.model.WorkerResourceConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfig
  ): zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly = new Wrapper(
    impl
  )
}
