package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.ImageUri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageConfigurationInput(
    imageUri: Optional[ImageUri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ImageConfigurationInput = {
    import ImageConfigurationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ImageConfigurationInput
      .builder()
      .optionallyWith(
        imageUri.map(value => ImageUri.unwrap(value): java.lang.String)
      )(_.imageUri)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly =
    zio.aws.emrserverless.model.ImageConfigurationInput.wrap(buildAwsValue())
}
object ImageConfigurationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ImageConfigurationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.ImageConfigurationInput =
      zio.aws.emrserverless.model
        .ImageConfigurationInput(imageUri.map(value => value))
    def imageUri: Optional[ImageUri]
    def getImageUri: ZIO[Any, AwsError, ImageUri] =
      AwsError.unwrapOptionField("imageUri", imageUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ImageConfigurationInput
  ) extends zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly {
    override val imageUri: Optional[ImageUri] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUri())
      .map(value => zio.aws.emrserverless.model.primitives.ImageUri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ImageConfigurationInput
  ): zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly = new Wrapper(
    impl
  )
}
